package com.zksy.szpt.domain;

public class CurrentUserInfo {
    private String userId;
    private String userName;
    private String deptCode;
    private String ip;

    private CurrentUserInfo(CurrentUserInfoBuilder builder) {
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.deptCode = builder.deptCode;
        this.ip = builder.ip;
    }

    // 建造器类
    public static class CurrentUserInfoBuilder {
        private String userId; // 必选项，用 final 修饰
        private String userName;  // 必选项，用 final 修饰
        private String deptCode;
        private String ip;// 可选项，不用 final 修饰

        public CurrentUserInfoBuilder userId(String userId) { // 可选参数
            this.userId = userId;
            return this;
        }

        public CurrentUserInfoBuilder userName(String userName) { // 可选参数
            this.userName = userName;
            return this;
        }

        public CurrentUserInfoBuilder deptCode(String deptCode) { // 可选参数
            this.deptCode = deptCode;
            return this;
        }

        public CurrentUserInfoBuilder ip(String ip) { // 可选参数
            this.ip = ip;
            return this;
        }

        public CurrentUserInfo build() {
            return new CurrentUserInfo(this);
        }
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDeptCode() {
        return deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}