import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.internal.DefaultShellCallback;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * 代码方式生成逆向代码.MyBatis逆向工程.
 * 不通过插件方式运行，因为自定义的注释类用插件方式会报错Cannot instantiate object of type com.zksy.szpt.config.MybatisGenerator
 * 直接运行此类即可
 */
public class MybatisGenerator {
    public static void main(String[] args) throws Exception {
        //MBG执行谊程中的警告信息
        List<String> warnings = new ArrayList<>();
        //当生成的代码重复时,质盖原代码
        boolean overwrite = true;
        //读取MBG配置文件
        InputStream is = MybatisGenerator.class.getResourceAsStream("./generatorConfig.xml");

        ConfigurationParser cParse = new ConfigurationParser(warnings);
        Configuration configuration = cParse.parseConfiguration(is);
        DefaultShellCallback callback = new DefaultShellCallback(overwrite);
        //创建MBG
        MyBatisGenerator myBatisGenerator = new MyBatisGenerator(configuration, callback, warnings);
        //执行生成代码
        myBatisGenerator.generate(null);
        //输出警告信息
        for (String warning : warnings) {
            System.out.println(warning);
        }
    }
}

