package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.XxYjrwDTO;
import com.zksy.szpt.service.XxYjrwService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "义警任务服务")
@RequestMapping("/rest/xxYjrw")
@RestController
@Validated
public class XxYjrwController {
    private final XxYjrwService service;

    public XxYjrwController(XxYjrwService service) {
        this.service = service;
    }

    @ApiOperation(value = "新增义警任务信息数据")
    @PostMapping("/add")
    public Integer add(@RequestBody @Validated XxYjrwDTO dto) {
        return service.addXxYjrw(dto);
    }

    @ApiOperation(value = "修改义警任务数据")
    @PostMapping("/update")
    public Integer update(@RequestBody @Validated XxYjrwDTO dto) {
        return service.update(dto);
    }

    @ApiOperation(value = "删除义警任务信息数据")
    @GetMapping("/delete")
    public Integer delete(@RequestParam(name = "rwid") String rwid) {
        return service.delete(rwid);
    }

}
