package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.SzptFwxxDTO;
import com.zksy.szpt.service.SzptFwxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptFwxxController {

    private final SzptFwxxService szptFwxxService;

    public SzptFwxxController(SzptFwxxService szptFwxxService) {
        this.szptFwxxService = szptFwxxService;
    }


    @ApiOperation(value="新增房屋信息数据")
    @PostMapping("/addSzptFwxx")
    public Integer addSzptFwxx(@RequestBody @Validated SzptFwxxDTO szptFwxxDTO){
        return szptFwxxService.addSzptFwxx(szptFwxxDTO);
    }

    @ApiOperation(value="编辑SzptFwxx数据")
    @PostMapping("/updateSzptFwxx")
    public Integer updateSzptFwxx(@RequestBody @Validated SzptFwxxDTO szptFwxxDTO){
        return szptFwxxService.updateSzptFwxx(szptFwxxDTO);
    }

    @ApiOperation(value = "删除SzptFwxx数据")
    @PostMapping("/deleteSzptFwxx")
    public Integer deleteSzptFwxx(@RequestBody List<String> ids) {
        return szptFwxxService.deleteSzptFwxx(ids);
    }
}
