package com.zksy.szpt;

import cn.hutool.crypto.digest.DigestUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zksy.szpt.domain.ListImageType;
import com.zksy.szpt.domain.UploadImageDTO;
import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.domain.po.XxShxxyDw;
import com.zksy.szpt.service.AppStoreService;
import com.zksy.szpt.util.EncryptUtil;
import com.zksy.szpt.util.SignatureUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;
import java.util.*;

/**
 * A simple unit test
 */
@SpringBootTest()
public class MainTest {

    String nonce = "2";
    String timestampStr = "21";
    String appId = "1872576325743943682";

    @Resource
    private ObjectMapper objectMapper;

    @Resource
    private AppStoreService appStoreService;

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("任务完成情况")
    public void xxRwwcqkTest() {
        //请求参数
        XxRwwcqkDTO xxRwwcqkDTO = new XxRwwcqkDTO();
        xxRwwcqkDTO.setRwid("12345678");
        xxRwwcqkDTO.setXxyid("123456785");
        xxRwwcqkDTO.setShrid("123456785");
        xxRwwcqkDTO.setWczt("1");
        xxRwwcqkDTO.setBmzt("1");
//        TestHttpUtil.signatureAndRequest("/rest/index/addXxRwwcqk", xxRwwcqkDTO, XxRwwcqkDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/index/updateXxRwwcqk", xxRwwcqkDTO, XxRwwcqkDTO.class);
    }

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("账户信息")
    public void zhxxtest() {
        //请求参数
        XxZhxxDTO dto = new XxZhxxDTO();
        dto.setZhid("12345678");
        dto.setXxyid("11");
        dto.setZt("2");
        dto.setClbz("2");
//        TestHttpUtil.signatureAndRequest("/rest/xxZhxx/add", dto, XxZhxxDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxZhxx/update", dto, XxZhxxDTO.class);
    }

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("账户积分变更")
    public void test1() {
        //请求参数
        XxZhjfbgDTO dto = new XxZhjfbgDTO();
//        dto.setZhid("12345678");
        dto.setDhid("12345678");
        dto.setQbid("2");
        dto.setBgsj(new Date());
//        TestHttpUtil.signatureAndRequest("/rest/xxZhjfbg/add", dto, XxZhjfbgDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxZhjfbg/update", dto, XxZhjfbgDTO.class);
    }


    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("文件上传")
    public void uploadFileTest() {
        nonce = UUID.randomUUID().toString();
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);

        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        UploadImageDTO uploadImageDTO = new UploadImageDTO();
        uploadImageDTO.setImagePath("http://192.168.168.219/guoqing1.jpg");
        uploadImageDTO.setImageType(ListImageType.FACE);
        String json = null;
        try {
            json = objectMapper.writeValueAsString(uploadImageDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/image/upload")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(uploadImageDTO), XxRwwcqkDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("义警任务")
    public void test4() {
        //请求参数
        XxYjrwDTO dto = new XxYjrwDTO();
//        dto.setZhid("12345678");
        dto.setRwid("1234567856");
        dto.setRwbt("1");
        dto.setRwnr("11111");
        dto.setGzrs(1L);
        dto.setSfsh(1);
        dto.setWcrs(1L);
//        TestHttpUtil.signatureAndRequest("/rest/xxYjrw/add", dto, XxYjrwDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxYjrw/update", dto, XxYjrwDTO.class);
    }

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("义警队伍代码")
    public void test5() {
        //请求参数
        XxYjdwdmDTO dto = new XxYjdwdmDTO();
//        dto.setZhid("12345678");
        dto.setDwlx(Integer.valueOf(1));
        dto.setId("12345678");
        dto.setMchid("11111");
        dto.setZt("1");
        dto.setYjdwmc("test");
//        TestHttpUtil.signatureAndRequest("/rest/xxYjdwdm/add", dto, XxYjdwdmDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxYjdwdm/update", dto, XxYjdwdmDTO.class);
    }

    @Test
    @DisplayName("社会信息员队伍")
    public void test6() {
        XxShxxyDwDTO dto = new XxShxxyDwDTO();
        dto.setId("12345678");
        dto.setDwdm("12345678");
        dto.setShxxyid("12345678");
//        TestHttpUtil.signatureAndRequest("/rest/xxShxxyDw/add", dto, XxShxxyDwDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxShxxyDw/update", dto, XxShxxyDwDTO.class);
    }

    @Test
    @DisplayName("社会信息员")
    public void test7() {
        XxShxxyDTO dto = new XxShxxyDTO();
        dto.setXxyid("12345678");
        dto.setZt("1");
        dto.setSbfszt("1");
        dto.setShrid("1");
//        TestHttpUtil.signatureAndRequest("/rest/xxShxxy/add", dto, XxShxxyDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxShxxy/update", dto, XxShxxyDTO.class);
    }


    @Test
    @DisplayName("删除服务")
    public void testdelete() {
        List<String> ids = new ArrayList<>();
        ids.add("12345678");
        ids.add("123456785");
        CommonDelParamDTO dto=new CommonDelParamDTO();
        dto.setIds(ids);
//        String url="xxShxxyDw/delete";
//        String url="xxShxxy/delete";
//        String url="xxYjdwdm/delete";
//        String url="xxYjrw/delete";
//        String url="xxZhjfbg/delete";
        String url = "xxZhxx/delete";
        TestHttpUtil.signatureAndRequest("/rest/"+url, dto, CommonDelParamDTO.class);
    }

}
