package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.SzptFwxxDTO;
import com.zksy.szpt.service.SzptFwxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptFwxxController {

    private final SzptFwxxService szptFwxxService;

    public SzptFwxxController(SzptFwxxService szptFwxxService) {
        this.szptFwxxService = szptFwxxService;
    }


    @ApiOperation(value="新增房屋信息数据")
    @PostMapping("/addSzptFwxx")
    public Integer addSzptFwxx(@RequestBody @Validated SzptFwxxDTO szptFwxxDTO){
        return szptFwxxService.addSzptFwxx(szptFwxxDTO);
    }
}
