package com.zksy.szpt.util;

import cn.hutool.crypto.digest.DigestUtil;
import org.springframework.util.StringUtils;

import java.util.UUID;

public class SignatureUtil {
    /**
     * 生成签名
     *
     * @param body      请求体
     * @param secretKey 密钥
     * @param nonce     随机数
     * @param timestamp 时间戳
     * @return 签名
     */
    public static String generateSignature(String body, String secretKey, String nonce, String timestamp) {
        if (!StringUtils.hasText(body) || !StringUtils.hasText(secretKey) || !StringUtils.hasText(nonce) || !StringUtils.hasText(timestamp)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        // 按照 secretKey + nonce + timestamp + body 的顺序拼接字符串
        String data = String.format("%s%s%s%s", secretKey, nonce, timestamp, body);
        System.out.println("data = " + data);
        // 使用MD5算法计算签名
        String sign = DigestUtil.md5Hex(data);
        return sign;
    }

    public static void main(String[] args) {
        // 示例参数
        String body = "{\n" +
                "  \"fromAccountId\": \"张三\",\n" +
                "  \"toAccountId\": \"李四\",\n" +
                "  \"transferPrice\": 100\n" +
                "}";

        //秘钥
        String secretKey = "b0e8668b-bcf2-4d73-abd4-893bbc1c6079";
        // 随机数
        String nonce = UUID.randomUUID().toString().replace("-", "");
        // 时间戳
        long timestamp = System.currentTimeMillis() / 1000;

        // 生成签名
        String sign = generateSignature(body, secretKey, nonce, String.valueOf(timestamp));

        // 输出生成的签名
        System.out.println("X-Sign: " + sign);
        System.out.println("X-Nonce: " + nonce);
        System.out.println("X-Timestamp: " + timestamp);
    }
}
