package com.zksy.szpt.aspect;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import com.zksy.szpt.domain.HttpResult;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import java.lang.reflect.Method;
import java.lang.reflect.Type;

@RestControllerAdvice(basePackages = "com.zksy.szpt.controller")
public class ResponseBodyAnalysis implements ResponseBodyAdvice {
    private final ObjectMapper Mapper;

    public ResponseBodyAnalysis(ObjectMapper mapper) {
        Mapper = mapper;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter arg1,
                                  MediaType arg2, Class arg3, ServerHttpRequest arg4,
                                  ServerHttpResponse arg5) {
        if (body instanceof HttpResult) {
            return body;//异常处理
        } else {
            HttpResult httpResult = new HttpResult(body);
            if (body instanceof String) {//如果control层返回的结果是字符串，则需要手动转换
                try {
                    return Mapper.writeValueAsString(httpResult);
                } catch (JsonProcessingException e) {

                }
            } else if (body == null) {//特殊情况需要，string却返回null的时候
                Method method = arg1.getMethod();
                Type type = method.getReturnType();
                if ("java.lang.String".equals(type.getTypeName())) {
                    try {
                        return Mapper.writeValueAsString(httpResult);
                    } catch (JsonProcessingException e) {

                    }
                }
            }
            return httpResult;//其他类型处理
        }
    }

    @Override
    public boolean supports(MethodParameter arg0, Class arg1) {
        return true;
    }
}