package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.CommonDelIntDTO;
import com.zksy.szpt.domain.dto.SzptClockInDTO;
import com.zksy.szpt.domain.po.SzptClockIn;
import com.zksy.szpt.mapper.SzptClockInMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptClockInService {
    @Resource
    private SzptClockInMapper szptClockInMapper;

    public Integer addSzptClockIn(SzptClockInDTO szptClockInDTO) {
        SzptClockIn szptClockIn = BeanMapperUtil.map(szptClockInDTO, SzptClockIn.class);
        return szptClockInMapper.insert(szptClockIn);
    }

    public Integer updateSzptClockIn(SzptClockInDTO szptClockInDTO) {
        SzptClockIn szptClockIn = BeanMapperUtil.map(szptClockInDTO, SzptClockIn.class);
        LambdaUpdateWrapper<SzptClockIn> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptClockIn::getId, szptClockIn.getId());
        return szptClockInMapper.update(szptClockIn,wrapper);
    }

    public Integer deleteSzptClockIn(CommonDelIntDTO commonDelIntDTO) {
        LambdaQueryWrapper<SzptClockIn> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptClockIn::getId, commonDelIntDTO.getIds());
        return szptClockInMapper.delete(wrapper);
    }
}
