package com.zksy.szpt.controller;

import com.zksy.szpt.domain.PageInfo;
import com.zksy.szpt.domain.bo.SzptFwxxBO;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptFwxxDTO;
import com.zksy.szpt.domain.dto.SzptFwxxQueryDTO;
import com.zksy.szpt.service.SzptFwxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


@Api(tags = "房屋信息")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptFwxxController {

    private final SzptFwxxService szptFwxxService;

    public SzptFwxxController(SzptFwxxService szptFwxxService) {
        this.szptFwxxService = szptFwxxService;
    }

    @ApiOperation(value="查询房屋信息数据")
    @PostMapping("/querySzptFwxx")
    public PageInfo<SzptFwxxBO> querySzptFwxx(@RequestBody @Validated SzptFwxxQueryDTO szptFwxxQueryDTO){
        return szptFwxxService.querySzptFwxx(szptFwxxQueryDTO);
    }

    @ApiOperation(value="新增房屋信息数据")
    @PostMapping("/addSzptFwxx")
    public Integer addSzptFwxx(@RequestBody @Validated SzptFwxxDTO szptFwxxDTO){
        return szptFwxxService.addSzptFwxx(szptFwxxDTO);
    }

    @ApiOperation(value="编辑SzptFwxx数据")
    @PostMapping("/updateSzptFwxx")
    public Integer updateSzptFwxx(@RequestBody @Validated SzptFwxxDTO szptFwxxDTO){
        return szptFwxxService.updateSzptFwxx(szptFwxxDTO);
    }

    @ApiOperation(value = "删除SzptFwxx数据")
    @PostMapping("/deleteSzptFwxx")
    public Integer deleteSzptFwxx(@RequestBody @Validated CommonDelDTO commonDelDTO) {
        return szptFwxxService.deleteSzptFwxx(commonDelDTO);
    }
}
