package com.zksy.szpt.domain;

public enum HttpResultState {
    SUCCESS(9000, "成功"),

    INVALID_PARAMETER(9020, "无效的输入参数"),

    NOTIFICATION(9030, "警告"),

    MULTI_DEVICE_LOGIN(9040, "登录已失效,账户已在别处登录,请重新登录"),
    EXPIRE(9041, "登录已经过期,请重新登录"),
    INVALID_TOKEN(9042, "身份验证失败"),

    GATEWAY(9050, "请求的服务不存在，请联系管理员"),

    DATABASE(9060, "服务器错误1，请联系管理员"),
    DUPLICATED_KEY(9061, "数据已存在"),

    NOT_FOUND(9070, "请求的资源不存在"),

    DEGRADATION(9080, "服务降级"),
    ERROR(9999, "服务器错误2，请联系管理员");



    HttpResultState(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    private Integer code;
    private String message;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
