package com.zksy.szpt.service;

import com.zksy.szpt.domain.UploadImageDTO;
import com.zksy.szpt.domain.po.XxImgfile;
import com.zksy.szpt.exception.NotificationException;
import com.zksy.szpt.mapper.XxImgfileMapper;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

import java.net.URISyntaxException;

@Service
public class ImageUploadService {
    private final XxImgfileMapper xxImgfileMapper;

    public ImageUploadService(XxImgfileMapper xxImgfileMapper) {
        this.xxImgfileMapper = xxImgfileMapper;
    }

    public Integer upload(UploadImageDTO uploadImageDTO) throws NotificationException {
        // 创建 WebClient 实例用于下载文件
        WebClient webClient = WebClient.builder()
                .baseUrl(uploadImageDTO.getImagePath())
                .build();
        // 下载文件到内存中的字节数组
        Mono<byte[]> fileContentMono = webClient.get()
                .uri("")
                .retrieve()
                .bodyToMono(byte[].class)
                .onErrorResume(WebClientResponseException.class, ex -> {
                    System.err.println("WebClientResponseException: " + ex.getResponseBodyAsString());
                    return Mono.error(new NotificationException(uploadImageDTO.getImagePath() + "，Failed to download file: " + ex.getStatusText()));
                })
                .onErrorResume(URISyntaxException.class, ex -> {
                    System.err.println("URISyntaxException: " + ex.getMessage());
                    return Mono.error(new NotificationException(uploadImageDTO.getImagePath() + "，Invalid URL format"));
                })
                .onErrorResume(Exception.class, ex -> {
                    System.err.println("General Exception: " + ex.getMessage());
                    return Mono.error(new NotificationException(uploadImageDTO.getImagePath() + "，An error occurred while downloading the file"));
                });

        XxImgfile xxImgfile = new XxImgfile();
        xxImgfile.setOurl(uploadImageDTO.getImagePath());
        xxImgfile.setNwzh("0");
        // 等待文件内容下载完成
        try {
            byte[] fileContent = fileContentMono.block();
            if (fileContent == null) {
                throw new NotificationException("Failed to download file");
            }
            xxImgfile.setData(fileContent);
            return xxImgfileMapper.insert(xxImgfile);
        } catch (Exception e) {
            throw new NotificationException(uploadImageDTO.getImagePath() + "，An error occurred while downloading the file");
        }
        // 将文件内容插入数据库
//        fileContentMono.flatMap(fileContent -> {
//            try {
//                xxImgfile.setData(fileContent);
//                return Mono.just(xxImgfileMapper.insert(xxImgfile));
//            } catch (Exception e) {
//                e.printStackTrace();
//                return Mono.error(e);
//            }
//        }).subscribe(rowsAffected -> {
//            System.out.println("Rows affected: " + rowsAffected);
//        }, error -> {
//            error.printStackTrace();
//        });
    }
}
