package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelParamDTO;
import com.zksy.szpt.domain.dto.XxZhjfbgDTO;
import com.zksy.szpt.domain.po.XxZhjfbg;
import com.zksy.szpt.mapper.XxZhjfbgMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class XxZhjfbgService {

    @Resource
    private XxZhjfbgMapper xxZhjfbgMapper;

    public Integer addXxZhjfbg(XxZhjfbgDTO dto) {
        XxZhjfbg xxZhjfbg = BeanMapperUtil.map(dto, XxZhjfbg.class);
        return xxZhjfbgMapper.insert(xxZhjfbg);
    }

    public Integer update(XxZhjfbgDTO dto) {
        XxZhjfbg xxZhjfbg = BeanMapperUtil.map(dto, XxZhjfbg.class);
        LambdaUpdateWrapper<XxZhjfbg> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(XxZhjfbg::getDhid, xxZhjfbg.getDhid());
        return xxZhjfbgMapper.update(xxZhjfbg,wrapper);
    }


    public Integer delete(CommonDelParamDTO dto) {
        LambdaQueryWrapper<XxZhjfbg> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(XxZhjfbg::getDhid, dto.getIds());
        return xxZhjfbgMapper.delete(wrapper);
    }
}
