package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.XxShxxyDTO;
import com.zksy.szpt.domain.po.XxShxxy;
import com.zksy.szpt.mapper.XxShxxyMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class XxShxxyService {

    @Resource
    private XxShxxyMapper xxShxxyMapper;

    public Integer addXxShxxy(XxShxxyDTO dto) {
        XxShxxy xxShxxy = BeanMapperUtil.map(dto, XxShxxy.class);
        return xxShxxyMapper.insert(xxShxxy);
    }


    public Integer update(XxShxxyDTO dto) {
        XxShxxy xxZhxx = BeanMapperUtil.map(dto, XxShxxy.class);
        LambdaUpdateWrapper<XxShxxy> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(XxShxxy::getXxyid, xxZhxx.getXxyid());
        return xxShxxyMapper.update(xxZhxx,wrapper);
    }


    public Integer delete(String id) {
        LambdaQueryWrapper<XxShxxy> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(XxShxxy::getXxyid, id);
        return xxShxxyMapper.delete(wrapper);
    }
}
