package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.AppStoreDTO;
import com.zksy.szpt.service.AppStoreService;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@Api(tags = "appKey管理")
@RequestMapping("/rest/appStore")
@RestController
public class AppStoreController {
    private final AppStoreService appStoreService;

    public AppStoreController(AppStoreService infApiSettingService) {
        this.appStoreService = infApiSettingService;
    }

    @PostMapping("/getAppSecretByAppKey")
    public Object infSetting(@RequestBody AppStoreDTO appStoreDTO) {
        return appStoreService.getAppSecretByAppKey("1");
    }

    @PostMapping("/insertAppStore")
    public Integer insertAppStore(@RequestBody @Valid AppStoreDTO appStoreDTO) {
        return appStoreService.insertAppStore(appStoreDTO);
    }
}
