package com.zksy.szpt.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;


/**
 * Created by wcy on 2023/5/14.
 */
@Configuration
@EnableSwagger2
public class SwaggerConfig {

    ApiInfo apiInfo = new ApiInfoBuilder()
//            .title("模块服务接口文档")
//            .description("服务接口文档，遵循RESTful API设计规范")
//            .contact(new Contact("wcy", "www.baidu.com", "4"))
//            .version("1.0")
            .build();

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
//                .groupName("system")
                .apiInfo(apiInfo)
                .select()
                //以扫描包的方式
                .apis(RequestHandlerSelectors.basePackage("com.zksy.szpt.controller"))
                .paths(PathSelectors.any())
                .build();
    }
}
