package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.SzptClockInDTO;
import com.zksy.szpt.domain.dto.SzptClockInRulesDTO;
import com.zksy.szpt.domain.dto.SzptFwxxDTO;
import com.zksy.szpt.domain.dto.XxRwwcqkDTO;
import com.zksy.szpt.service.IndexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class IndexController {
    private final IndexService indexService;

    public IndexController(IndexService indexService) {
        this.indexService = indexService;
    }

    @ApiOperation(value = "新增xx_rwwcqk数据")
    @PostMapping("/addXxRwwcqk")
    public Integer addXxRwwcqk(@RequestBody @Valid XxRwwcqkDTO xxRwwcqkDTO) {
        return indexService.addXxRwwcqk(xxRwwcqkDTO);
    }

    @ApiOperation(value="新增szpt_clock_in数据")
    @PostMapping("/addSzptClockIn")
    public Integer addSzptClockIn(@RequestBody @Valid SzptClockInDTO szptClockInDTO){
        return indexService.addSzptClockIn(szptClockInDTO);
    }

    @ApiOperation(value="新增szpt_clock_in_rules数据")
    @PostMapping("/addSzptClockInRules")
    public Integer addSzptClockInRules(@RequestBody @Valid SzptClockInRulesDTO szptClockInRulesDTO){
        return indexService.addSzptClockInRules(szptClockInRulesDTO);
    }

    @ApiOperation(value="新增szpt_fwxx数据")
    @PostMapping("/addSzptFwxx")
    public Integer addSzptFwxx(@RequestBody @Validated SzptFwxxDTO szptFwxxDTO){
        return indexService.addSzptFwxx(szptFwxxDTO);
    }
}
