package com.zksy.szpt.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.util.Date;

public class SzptFwxxBO {
    /**
     * 区域ID
     */
    @ApiModelProperty(value = "区域ID")
    private String qyid;

    /**
     * 场所ID
     */
    @ApiModelProperty(value = "场所ID")
    private String csid;

    /**
     * 房屋简称
     */
    @ApiModelProperty(value = "房屋简称")
    private String fwjc;

    /**
     * 居住情况(1059)：01-出租，02-自住，03-借住，04-空置
     */
    @ApiModelProperty(value = "居住情况(1059)：01-出租，02-自住，03-借住，04-空置")
    private String jzqk;

    /**
     * 出租用途(1043)：03-出租房，04-经营用房，06-员工宿舍，07-网约房
     */
    @ApiModelProperty(value = "出租用途(1043)：03-出租房，04-经营用房，06-员工宿舍，07-网约房")
    private String czyt;

    /**
     * 户型结构(1042)：01-1室，02-2室，03-3室，04-4室，05-5室，06-6室，07-7室，08-8室，09-9室
     */
    @ApiModelProperty(value = "户型结构(1042)：01-1室，02-2室，03-3室，04-4室，05-5室，06-6室，07-7室，08-8室，09-9室")
    private String hxjg;

    /**
     * 房型ID
     */
    @ApiModelProperty(value = "房型ID")
    private String fxid;

    /**
     * 出租备案(1044)：1-已备案，2-未备案
     */
    @ApiModelProperty(value = "出租备案(1044)：1-已备案，2-未备案")
    private String czba;

    /**
     * 出租备案号
     */
    @ApiModelProperty(value = "出租备案号")
    private String czbah;

    /**
     * 出租备案起始
     */
    @ApiModelProperty(value = "出租备案起始")
    private String czbaqs;

    /**
     * 出租备案截止
     */
    @ApiModelProperty(value = "出租备案截止")
    private String czbajz;

    /**
     * 房主姓名
     */
    @ApiModelProperty(value = "房主姓名")
    private String fzxm;

    /**
     * 房主身份证号
     */
    @ApiModelProperty(value = "房主身份证号")
    private String fzsfzh;

    /**
     * 房主人员id
     */
    @ApiModelProperty(value = "房主人员id")
    private String fzryid;

    /**
     * 房主联系电话
     */
    @ApiModelProperty(value = "房主联系电话")
    private String fzlxdh;

    /**
     * 房屋楼层
     */
    @ApiModelProperty(value = "房屋楼层")
    private String fwlc;

    /**
     * 房屋房间号（数字）
     */
    @ApiModelProperty(value = "房屋房间号（数字）")
    private String fwfjh;

    /**
     * 房屋状态(3136)：0-废弃，1-空闲，2-在住，3-保留
     */
    @ApiModelProperty(value = "房屋状态(3136)：0-废弃，1-空闲，2-在住，3-保留")
    private String fwzt;

    /**
     * 清洁模式(3137)：0-无，1-默认清洁
     */
    @ApiModelProperty(value = "清洁模式(3137)：0-无，1-默认清洁")
    private String qjms;

    /**
     * 清洁状态(3138)：1-净，2-脏
     */
    @ApiModelProperty(value = "清洁状态(3138)：1-净，2-脏")
    private String qjzt;

    /**
     * 最近清洁时间
     */
    @ApiModelProperty(value = "最近清洁时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date zjqjsj;

    /**
     * 账单日期
     */
    @ApiModelProperty(value = "账单日期")
    private String zdrq;

    /**
     * 账单周期(3161)：1-月付，2-季付，3-半年付，4-年付
     */
    @ApiModelProperty(value = "账单周期(3161)：1-月付，2-季付，3-半年付，4-年付")
    private String zdzq;

    /**
     * 房屋参数JSON，扩展用
     */
    @ApiModelProperty(value = "房屋参数JSON，扩展用")
    private String fwcs;

    /**
     * 管理人类型(3175)：0-房主本人，1-亲戚，2-朋友，3-二房东，4-运营公司，5-运营子场所
     */
    @ApiModelProperty(value = "管理人类型(3175)：0-房主本人，1-亲戚，2-朋友，3-二房东，4-运营公司，5-运营子场所")
    private String glrlx;

    /**
     * 管理人姓名
     */
    @ApiModelProperty(value = "管理人姓名")
    private String glrxm;

    /**
     * 管理人身份证号
     */
    @ApiModelProperty(value = "管理人身份证号")
    private String glrsfzh;

    /**
     * 管理人人员id
     */
    @ApiModelProperty(value = "管理人人员id")
    private String glrryid;

    /**
     * 管理人联系电话
     */
    @ApiModelProperty(value = "管理人联系电话")
    private String glrlxdh;

    /**
     * 管理运营公司名称
     */
    @ApiModelProperty(value = "管理运营公司名称")
    private String glrgsmc;

    /**
     * 子场所ID
     */
    @ApiModelProperty(value = "子场所ID")
    private String zcsid;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String bz;

    /**
     * 访客登记自动审核标志(3001)：0-否1-是
     */
    @ApiModelProperty(value = "访客登记自动审核标志(3001)：0-否1-是")
    @NotBlank(message = "访客登记自动审核标志(3001)：0-否1-是不能为空")
    private String fkdjzdsh;

    /**
     * 其他房屋用途
     */
    @ApiModelProperty(value = "其他房屋用途")
    private String qtfwyt;

    /**
     * 健康码核验时间
     */
    @ApiModelProperty(value = "健康码核验时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date jkmhysj;

//    /**
//     * 数据归属单位代码
//     */
//    private String sjgsdwdm;
//
//
//    /**
//     * 数据归属单位名称
//     */
//    private String sjgsdwmc;

    /**
     * 房主证件照片
     */
    @ApiModelProperty(value = "房主证件照片")
    private String fzzjzp;

    public String getQyid() {
        return qyid;
    }

    public void setQyid(String qyid) {
        this.qyid = qyid == null ? null : qyid.trim();
    }

    public String getCsid() {
        return csid;
    }

    public void setCsid(String csid) {
        this.csid = csid == null ? null : csid.trim();
    }

    public String getFwjc() {
        return fwjc;
    }

    public void setFwjc(String fwjc) {
        this.fwjc = fwjc == null ? null : fwjc.trim();
    }

    public String getJzqk() {
        return jzqk;
    }

    public void setJzqk(String jzqk) {
        this.jzqk = jzqk == null ? null : jzqk.trim();
    }

    public String getCzyt() {
        return czyt;
    }

    public void setCzyt(String czyt) {
        this.czyt = czyt == null ? null : czyt.trim();
    }

    public String getHxjg() {
        return hxjg;
    }

    public void setHxjg(String hxjg) {
        this.hxjg = hxjg == null ? null : hxjg.trim();
    }

    public String getFxid() {
        return fxid;
    }

    public void setFxid(String fxid) {
        this.fxid = fxid == null ? null : fxid.trim();
    }

    public String getCzba() {
        return czba;
    }

    public void setCzba(String czba) {
        this.czba = czba == null ? null : czba.trim();
    }

    public String getCzbah() {
        return czbah;
    }

    public void setCzbah(String czbah) {
        this.czbah = czbah == null ? null : czbah.trim();
    }

    public String getCzbaqs() {
        return czbaqs;
    }

    public void setCzbaqs(String czbaqs) {
        this.czbaqs = czbaqs == null ? null : czbaqs.trim();
    }

    public String getCzbajz() {
        return czbajz;
    }

    public void setCzbajz(String czbajz) {
        this.czbajz = czbajz == null ? null : czbajz.trim();
    }

    public String getFzxm() {
        return fzxm;
    }

    public void setFzxm(String fzxm) {
        this.fzxm = fzxm == null ? null : fzxm.trim();
    }

    public String getFzsfzh() {
        return fzsfzh;
    }

    public void setFzsfzh(String fzsfzh) {
        this.fzsfzh = fzsfzh == null ? null : fzsfzh.trim();
    }

    public String getFzryid() {
        return fzryid;
    }

    public void setFzryid(String fzryid) {
        this.fzryid = fzryid == null ? null : fzryid.trim();
    }

    public String getFzlxdh() {
        return fzlxdh;
    }

    public void setFzlxdh(String fzlxdh) {
        this.fzlxdh = fzlxdh == null ? null : fzlxdh.trim();
    }

    public String getFwlc() {
        return fwlc;
    }

    public void setFwlc(String fwlc) {
        this.fwlc = fwlc == null ? null : fwlc.trim();
    }

    public String getFwfjh() {
        return fwfjh;
    }

    public void setFwfjh(String fwfjh) {
        this.fwfjh = fwfjh == null ? null : fwfjh.trim();
    }

    public String getFwzt() {
        return fwzt;
    }

    public void setFwzt(String fwzt) {
        this.fwzt = fwzt == null ? null : fwzt.trim();
    }

    public String getQjms() {
        return qjms;
    }

    public void setQjms(String qjms) {
        this.qjms = qjms == null ? null : qjms.trim();
    }

    public String getQjzt() {
        return qjzt;
    }

    public void setQjzt(String qjzt) {
        this.qjzt = qjzt == null ? null : qjzt.trim();
    }

    public Date getZjqjsj() {
        return zjqjsj;
    }

    public void setZjqjsj(Date zjqjsj) {
        this.zjqjsj = zjqjsj;
    }

    public String getZdrq() {
        return zdrq;
    }

    public void setZdrq(String zdrq) {
        this.zdrq = zdrq == null ? null : zdrq.trim();
    }

    public String getZdzq() {
        return zdzq;
    }

    public void setZdzq(String zdzq) {
        this.zdzq = zdzq == null ? null : zdzq.trim();
    }

    public String getFwcs() {
        return fwcs;
    }

    public void setFwcs(String fwcs) {
        this.fwcs = fwcs == null ? null : fwcs.trim();
    }

    public String getGlrlx() {
        return glrlx;
    }

    public void setGlrlx(String glrlx) {
        this.glrlx = glrlx == null ? null : glrlx.trim();
    }

    public String getGlrxm() {
        return glrxm;
    }

    public void setGlrxm(String glrxm) {
        this.glrxm = glrxm == null ? null : glrxm.trim();
    }

    public String getGlrsfzh() {
        return glrsfzh;
    }

    public void setGlrsfzh(String glrsfzh) {
        this.glrsfzh = glrsfzh == null ? null : glrsfzh.trim();
    }

    public String getGlrryid() {
        return glrryid;
    }

    public void setGlrryid(String glrryid) {
        this.glrryid = glrryid == null ? null : glrryid.trim();
    }

    public String getGlrlxdh() {
        return glrlxdh;
    }

    public void setGlrlxdh(String glrlxdh) {
        this.glrlxdh = glrlxdh == null ? null : glrlxdh.trim();
    }

    public String getGlrgsmc() {
        return glrgsmc;
    }

    public void setGlrgsmc(String glrgsmc) {
        this.glrgsmc = glrgsmc == null ? null : glrgsmc.trim();
    }

    public String getZcsid() {
        return zcsid;
    }

    public void setZcsid(String zcsid) {
        this.zcsid = zcsid == null ? null : zcsid.trim();
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz == null ? null : bz.trim();
    }

    public String getFkdjzdsh() {
        return fkdjzdsh;
    }

    public void setFkdjzdsh(String fkdjzdsh) {
        this.fkdjzdsh = fkdjzdsh == null ? null : fkdjzdsh.trim();
    }

    public String getQtfwyt() {
        return qtfwyt;
    }

    public void setQtfwyt(String qtfwyt) {
        this.qtfwyt = qtfwyt == null ? null : qtfwyt.trim();
    }

    public Date getJkmhysj() {
        return jkmhysj;
    }

    public void setJkmhysj(Date jkmhysj) {
        this.jkmhysj = jkmhysj;
    }

//    public String getSjgsdwmc() {
//        return sjgsdwmc;
//    }
//
//    public void setSjgsdwmc(String sjgsdwmc) {
//        this.sjgsdwmc = sjgsdwmc;
//    }
//
//    public String getSjgsdwdm() {
//        return sjgsdwdm;
//    }
//
//    public void setSjgsdwdm(String sjgsdwdm) {
//        this.sjgsdwdm = sjgsdwdm;
//    }

    public String getFzzjzp() {
        return fzzjzp;
    }

    public void setFzzjzp(String fzzjzp) {
        this.fzzjzp = fzzjzp == null ? null : fzzjzp.trim();
    }
}
