package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zksy.szpt.domain.PageInfo;
import com.zksy.szpt.domain.bo.SzptClockInRulesBO;
import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.domain.po.SzptClockInRules;
import com.zksy.szpt.mapper.SzptClockInRulesMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import com.zksy.szpt.util.UserContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class SzptClockInRulesService {
    @Resource
    private SzptClockInRulesMapper szptClockInRulesMapper;

    public PageInfo<SzptClockInRulesBO> querySzptClockInRules(SzptClockInRulesQueryDTO szptClockInRulesQueryDTO) {
        String deptCode  = UserContextHolder.get().getDeptCode();
        if(deptCode==null){
            throw new IllegalArgumentException("所属单位为空");
        }
        LambdaQueryWrapper<SzptClockInRules> wrapper = new LambdaQueryWrapper<>();
//        wrapper.eq(SzptClockIn::getSjgsdwdm, deptCode);
        if (szptClockInRulesQueryDTO.getName() != null) {
            wrapper.eq(SzptClockInRules::getName, szptClockInRulesQueryDTO.getName());
        }

        Page<SzptClockInRules> page = new Page<>(szptClockInRulesQueryDTO.getPageNum(),szptClockInRulesQueryDTO.getPageSize());
        Page<SzptClockInRules> resultPage = szptClockInRulesMapper.selectPage(page,wrapper);

        List<SzptClockInRulesBO> list = BeanMapperUtil.mapList(resultPage.getRecords(), SzptClockInRulesBO.class);
        return new PageInfo<>(resultPage.getTotal(),list,resultPage.getCurrent(),resultPage.getSize());
    }

    public Integer addSzptClockInRules(SzptClockInRulesDTO szptClockInRulesDTO) {
        SzptClockInRules szptClockInRules = BeanMapperUtil.map(szptClockInRulesDTO, SzptClockInRules.class);
        return szptClockInRulesMapper.insert(szptClockInRules);
    }

    public Integer updateSzptClockInRules(SzptClockInRulesDTO szptClockInRulesDTO) {
        SzptClockInRules szptClockInRules = BeanMapperUtil.map(szptClockInRulesDTO, SzptClockInRules.class);
        LambdaUpdateWrapper<SzptClockInRules> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptClockInRules::getId, szptClockInRules.getId());
        return szptClockInRulesMapper.update(szptClockInRules,wrapper);
    }

    public Integer deleteSzptClockInRules(CommonDelIntDTO commonDelIntDTO) {
        LambdaQueryWrapper<SzptClockInRules> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptClockInRules::getId, commonDelIntDTO.getIds());
        return szptClockInRulesMapper.delete(wrapper);
    }
}
