package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.XxYjdwdmDTO;
import com.zksy.szpt.service.XxYjdwdmService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "义警队伍代码服务")
@RequestMapping("/rest/xxYjrdwdm")
@RestController
@Validated
public class XxYjdwdmController {
    private final XxYjdwdmService service;

    public XxYjdwdmController(XxYjdwdmService service) {
        this.service = service;
    }

    @ApiOperation(value = "新增义警队伍代码数据")
    @PostMapping("/add")
    public Integer addXxYjdwdm(@RequestBody @Validated XxYjdwdmDTO dto) {
        return service.addXxYjdwdm(dto);
    }

    @ApiOperation(value = "修改义警队伍数据")
    @PostMapping("/update")
    public Integer update(@RequestBody @Validated XxYjdwdmDTO dto) {
        return service.update(dto);
    }

    @ApiOperation(value = "删除义警队伍数据")
    @GetMapping("/delete")
    public Integer delete(@RequestParam(name = "id") String id) {
        return service.delete(id);
    }

}
