package com.zksy.szpt.util;




import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;

import java.util.Collection;
import java.util.List;

public class BeanMapperUtil {

    private static MapperFactory MAPPER_FACTORY = new DefaultMapperFactory.Builder().build();
    public static <E, T> E map(T source, Class<E> destinationClass) {
        if (source == null) {
            return null;
        }
        return MAPPER_FACTORY.getMapperFacade().map(source, destinationClass);
    }

    public static <E, T> List<E> mapList(Collection<T> sourceList, Class<E> destinationClass) {
        return MAPPER_FACTORY.getMapperFacade().mapAsList(sourceList, destinationClass);
    }
}