package com.zksy.szpt.handler;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.handlers.StrictFill;
import com.zksy.szpt.domain.CurrentUserInfo;
import com.zksy.szpt.util.UserContextHolder;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 自动填充 create_time, update_time 字段
 * 该类策略如下：有值则不填充，无值则填充写入值，
 */
@Component
public class SzptMetaObjectHandler implements MetaObjectHandler {
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SzptMetaObjectHandler.class);

    @Override
    public void insertFill(MetaObject metaObject) {
        // 新增时自动填充 create_time, update_time 字段
//        this.strictInsertFill(metaObject, "createTime", Date.class, new Date());
//        this.strictInsertFill(metaObject, "cjsj", Date.class, new Date());

        CurrentUserInfo currentUserInfo = UserContextHolder.get();
        if (currentUserInfo == null) {
            log.error("当前用户信息为空，无法自动填充 create_time, update_time 字段");
        }

        List<StrictFill> fields = Arrays.asList(
                StrictFill.of("createTime", Date.class, new Date()),
                StrictFill.of("cjsj", Date.class, new Date()),
                StrictFill.of("gxsj", Date.class, new Date()),
                StrictFill.of("updateTime", Date.class, new Date()),
//                StrictFill.of("sjgsdwdm", String.class, "1"),
//                StrictFill.of("sjgsdwmc", String.class, "1"),
                StrictFill.of("createGajgjgdm", String.class, "1"),
                StrictFill.of("createGajgmc", String.class, "1"),
//                StrictFill.of("createId", String.class, "1"),
                StrictFill.of("createId", String.class, currentUserInfo.getUserId()),
                StrictFill.of("cjrid", String.class, "1"),
//                StrictFill.of("createBy", String.class, "1"),
                StrictFill.of("createBy", String.class, currentUserInfo.getUserId()),
                StrictFill.of("createTerminal", String.class, "1"),
//                StrictFill.of("createIp", String.class, "1"),
                StrictFill.of("createIp", String.class, currentUserInfo.getIp()),
                StrictFill.of("delFlag", Integer.class, 0)

//                StrictFill.of("del_flag", Integer.class,0)
        );
        this.strictInsertFill(findTableInfo(metaObject), metaObject, fields);
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        CurrentUserInfo currentUserInfo = UserContextHolder.get();
        if (currentUserInfo == null) {
            log.error("当前用户信息为空，无法自动填充 update_time 字段");
        }
        List<StrictFill> fields = Arrays.asList(
                StrictFill.of("updateTime", Date.class, new Date()),
                StrictFill.of("gxrid", String.class, "1"),
                StrictFill.of("gxsj", Date.class, new Date()),
                StrictFill.of("gxrxm", String.class, "测试"),
                StrictFill.of("update_gajgjgdm", String.class, '1'),
                StrictFill.of("update_gajgmc", String.class, '1'),
//                StrictFill.of("update_id", String.class, '1'),
                StrictFill.of("update_id", String.class, currentUserInfo.getUserId()),
//                StrictFill.of("update_by", String.class, '1'),
                StrictFill.of("update_by", String.class, currentUserInfo.getUserId()),
                StrictFill.of("update_time", Date.class, new Date()),
                StrictFill.of("update_terminal", String.class, '1'),
//                StrictFill.of("update_ip", String.class, '1'),
                StrictFill.of("update_ip", String.class, currentUserInfo.getIp())
//                StrictFill.of("del_flag", Integer.class,0)
        );
        this.strictUpdateFill(findTableInfo(metaObject), metaObject, fields);
//        this.strictInsertFill(metaObject, "updateTime", Date.class, new Date());
    }
}
