package com.zksy.szpt;

import cn.hutool.crypto.digest.DigestUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zksy.szpt.domain.ListImageType;
import com.zksy.szpt.domain.UploadImageDTO;
import com.zksy.szpt.domain.dto.XxRwwcqkDTO;
import com.zksy.szpt.domain.dto.XxZhjfbgDTO;
import com.zksy.szpt.domain.dto.XxZhxxDTO;
import com.zksy.szpt.service.AppStoreService;
import com.zksy.szpt.util.EncryptUtil;
import com.zksy.szpt.util.SignatureUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;
import java.util.Date;
import java.util.UUID;

/**
 * A simple unit test
 */
@SpringBootTest()
public class MainTest {

    String nonce = "2";
    String timestampStr = "21";
    String appId = "1";


    @Resource
    private ObjectMapper objectMapper;

    @Resource
    private AppStoreService appStoreService;
    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("任务完成情况")
    public void xxRwwcqkTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);

        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        XxRwwcqkDTO xxRwwcqkDTO = new XxRwwcqkDTO();
        xxRwwcqkDTO.setRwid("123456");
        xxRwwcqkDTO.setXxyid("123456");
        xxRwwcqkDTO.setShrid("123456");
        xxRwwcqkDTO.setWczt("1");
        xxRwwcqkDTO.setBmzt("1");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(xxRwwcqkDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/addXxRwwcqk")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(xxRwwcqkDTO), XxRwwcqkDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("任务完成情况")
    public void xxRwwcqkTest1() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce=String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
//        Assertions.fail(secretKey);
        //请求参数
        XxZhxxDTO dto = new XxZhxxDTO();
//        dto.setZhid("123456");
        dto.setXxyid("123456");
        dto.setZt("1");
        dto.setClbz("1");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(dto);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/addXxZhxx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(dto), XxZhxxDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("任务完成情况")
    public void test1() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce=String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
//        Assertions.fail(secretKey);
        //请求参数
        XxZhjfbgDTO dto = new XxZhjfbgDTO();
//        dto.setZhid("123456");
        dto.setDhid("123456");
        dto.setQbid("1");
        dto.setBgsj(new Date());
        String json = null;
        try {
            json = objectMapper.writeValueAsString(dto);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/addXxZhjfbg")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(dto), XxZhjfbgDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }


    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("文件上传")
    public void uploadFileTest() {
        nonce = UUID.randomUUID().toString();
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);

        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        UploadImageDTO uploadImageDTO = new UploadImageDTO();
        uploadImageDTO.setImagePath("http://192.168.168.219/guoqing1.jpg");
        uploadImageDTO.setImageType(ListImageType.FACE);
        String json = null;
        try {
            json = objectMapper.writeValueAsString(uploadImageDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/image/upload")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(uploadImageDTO), XxRwwcqkDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }
}
