package com.zksy.szpt;

import cn.hutool.crypto.digest.DigestUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.util.EncryptUtil;
import com.zksy.szpt.util.SignatureUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;

@SpringBootTest()
public class TestAppStore {
    String nonce = "2";
    String timestampStr = "21";
    String appId = "1872576325743943682";
    String appSecret = "2";


    @Resource
    private ObjectMapper objectMapper;

    /**
     * 新增AppId
     */
    @Test
    @DisplayName("新增AppId")
    public void addAppId() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        appSecret = DigestUtil.md5Hex(appSecret);
        Assertions.assertNotNull(appId, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        AppStoreDTO appStoreDTO = new AppStoreDTO();
        appStoreDTO.setAppKey("us");
        appStoreDTO.setAppSecret(DigestUtil.md5Hex("us"));
        appStoreDTO.setDeptCode("123456");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(appStoreDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, appSecret);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/appStore/insertAppStore")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(appStoreDTO), XxRwwcqkDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    @Test
    @DisplayName("更新AppId的密钥")
    public void updateAppIdSecret() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        appSecret = DigestUtil.md5Hex(appSecret);
        Assertions.assertNotNull(appId, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        AppStoreDTO appStoreDTO = new AppStoreDTO();
        appStoreDTO.setAppKey("us");
        appStoreDTO.setAppSecret(DigestUtil.md5Hex("us11"));
        String json = null;
        try {
            json = objectMapper.writeValueAsString(appStoreDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, appSecret);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/appStore/updateAppIdSecret")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(appStoreDTO), XxRwwcqkDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }
}
