package com.zksy.szpt;

import cn.hutool.crypto.digest.DigestUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.service.AppStoreService;
import com.zksy.szpt.util.EncryptUtil;
import com.zksy.szpt.util.SignatureUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@SpringBootTest()
public class MainTestX {
    String nonce = "2";
    String timestampStr = "21";
    String appId = "1872576325743943682";


    @Resource
    private ObjectMapper objectMapper;

    @Resource
    private AppStoreService appStoreService;

    /**
     * ===================================================考勤===================================================
     */
    @Test
    @DisplayName("考勤--新增、更新")
    public void szptClockInTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        SzptClockInDTO szptClockInDTO = new SzptClockInDTO();
        szptClockInDTO.setId(100);
        szptClockInDTO.setCsid("123456111111111111111");
        szptClockInDTO.setSbqd("123456");
        szptClockInDTO.setXbqt("123456");
        szptClockInDTO.setXcqk("1");
        szptClockInDTO.setSbsj("1");
        szptClockInDTO.setSbr("123456");
        szptClockInDTO.setQdr("123456");
        szptClockInDTO.setQdrlxdh("123456");
        szptClockInDTO.setQddkdd("1");
        szptClockInDTO.setQddkzp("1");
        szptClockInDTO.setQtdkdd("1");
        szptClockInDTO.setQtdkzp("1");
        szptClockInDTO.setGkdj("1");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(szptClockInDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/updateSzptClockIn")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(szptClockInDTO), SzptClockInDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    @Test
    @DisplayName("考勤--删除")
    public void deleteClockInTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        List<Integer> ids = new ArrayList<>();
        ids.add(14);
        ids.add(15);
        CommonDelIntDTO commonDelIntDTO = new CommonDelIntDTO();
        commonDelIntDTO.setIds(ids);
        commonDelIntDTO.setSjgsdwdm("330102");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(commonDelIntDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/deleteSzptClockIn")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(commonDelIntDTO), CommonDelIntDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * ===================================================考勤规则===================================================
     */
    @Test
    @DisplayName("考勤规则--新增、更新")
    public void szptClockInRulesTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        SzptClockInRulesDTO szptClockInRulesDTO = new SzptClockInRulesDTO();
        szptClockInRulesDTO.setId(100);
        szptClockInRulesDTO.setName("123456");
        szptClockInRulesDTO.setCsid("123456");
        szptClockInRulesDTO.setChockInTime("123456");
        szptClockInRulesDTO.setClockInScope("1");
        szptClockInRulesDTO.setQrCode("1");
        szptClockInRulesDTO.setCslx("123456");
        szptClockInRulesDTO.setBz("123456");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(szptClockInRulesDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
//        String response = webClient.post().uri("/rest/index/addSzptClockInRules")
        String response = webClient.post().uri("/rest/index/updateSzptClockInRules")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(szptClockInRulesDTO), SzptClockInRulesDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    @Test
    @DisplayName("考勤规则--删除")
    public void deleteClockInRulesTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        List<Integer> ids = new ArrayList<>();
        ids.add(4);
        ids.add(100);
        CommonDelIntDTO commonDelIntDTO = new CommonDelIntDTO();
        commonDelIntDTO.setIds(ids);
        commonDelIntDTO.setSjgsdwdm("330102");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(commonDelIntDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/deleteSzptClockInRules")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(commonDelIntDTO), CommonDelIntDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * ===================================================房屋信息===================================================
     */
    @Test
    @DisplayName("房屋信息--新增、更新")
    public void szptFwxxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        SzptFwxxDTO szptFwxxDTO = new SzptFwxxDTO();
        szptFwxxDTO.setQyid("5");
        szptFwxxDTO.setCsid("123456");
        szptFwxxDTO.setFwjc("123456");
        szptFwxxDTO.setJzqk("1");
        szptFwxxDTO.setCzyt("1");
        szptFwxxDTO.setHxjg("1");
        szptFwxxDTO.setFxid("123456");
        szptFwxxDTO.setCzba("2");
        szptFwxxDTO.setCzbah("123456");
        szptFwxxDTO.setCzbaqs("1");
        szptFwxxDTO.setCzbajz("1");
        szptFwxxDTO.setFzxm("1");
        szptFwxxDTO.setFzsfzh("1");
        szptFwxxDTO.setFzryid("1");
        szptFwxxDTO.setFzlxdh("1");
        szptFwxxDTO.setFwlc("1");
        szptFwxxDTO.setFwfjh("1");
        szptFwxxDTO.setFwzt("1");
        szptFwxxDTO.setQjms("1");
        szptFwxxDTO.setQjzt("1");
        szptFwxxDTO.setZjqjsj(new Date());
        szptFwxxDTO.setZdrq("1");
        szptFwxxDTO.setZdzq("1");
        szptFwxxDTO.setFwcs("1");
        szptFwxxDTO.setGlrlx("1");
        szptFwxxDTO.setGlrxm("1");
        szptFwxxDTO.setGlrsfzh("1");
        szptFwxxDTO.setGlrryid("1");
        szptFwxxDTO.setGlrlxdh("1");
        szptFwxxDTO.setGlrgsmc("1");
        szptFwxxDTO.setZcsid("1");
        szptFwxxDTO.setBz("1");
        szptFwxxDTO.setFkdjzdsh("1");
        szptFwxxDTO.setQtfwyt("1");
        szptFwxxDTO.setJkmhysj(new Date());
        szptFwxxDTO.setSjgsdwdm("330102");
        szptFwxxDTO.setSjgsdwmc("1");
        szptFwxxDTO.setFzzjzp("1");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(szptFwxxDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/addSzptFwxx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(szptFwxxDTO), SzptFwxxDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    @Test
    @DisplayName("房屋信息--删除")
    public void deleteSzptFwxxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("5");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(commonDelDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        String json1 = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json1);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/deleteSzptFwxx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(commonDelDTO), CommonDelDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * ===================================================场所预警忽略对象===================================================
     */
    @Test
    @DisplayName("场所预警忽略对象--新增、更新")
    public void szptGdCsyjhldxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        SzptGdCsyjhldxDTO szptGdCsyjhldxDTO = new SzptGdCsyjhldxDTO();
        szptGdCsyjhldxDTO.setId("5");
        szptGdCsyjhldxDTO.setCsid("123456123456");
        szptGdCsyjhldxDTO.setYjlx("1");
        szptGdCsyjhldxDTO.setYjzlx("1");
        szptGdCsyjhldxDTO.setYwid("1");
        szptGdCsyjhldxDTO.setYwms("1");
        szptGdCsyjhldxDTO.setBz("123456");
        szptGdCsyjhldxDTO.setZt("1");

        String json = null;
        try {
            json = objectMapper.writeValueAsString(szptGdCsyjhldxDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
//        String response = webClient.post().uri("/rest/index/addSzptGdCsyjhldx")
        String response = webClient.post().uri("/rest/index/updateSzptGdCsyjhldx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(szptGdCsyjhldxDTO), SzptGdCsyjhldxDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    @Test
    @DisplayName("场所预警忽略对象--删除")
    public void deleteSzptGdCsyjhldxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("5");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(commonDelDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        String json1 = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json1);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/deleteSzptGdCsyjhldx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(commonDelDTO), CommonDelDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * ===================================================工地人员信息===================================================
     */
    @Test
    @DisplayName("工地人员信息--新增、更新")
    public void szptGdRyxxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        SzptGdRyxxDTO szptGdRyxxDTO = new SzptGdRyxxDTO();
        szptGdRyxxDTO.setId("7");
        szptGdRyxxDTO.setRkbm("1234561234561");
        szptGdRyxxDTO.setCsid("1123111111111111");
        szptGdRyxxDTO.setCjrlid("1");
        szptGdRyxxDTO.setXm("1");
        szptGdRyxxDTO.setXb("1");
        szptGdRyxxDTO.setLxdh("123456");
        szptGdRyxxDTO.setCyzjdm("1");
        szptGdRyxxDTO.setZjhm("5");
        szptGdRyxxDTO.setNl("1");
        szptGdRyxxDTO.setUrl("1");
        szptGdRyxxDTO.setMd5("1");
        szptGdRyxxDTO.setZjcxts(1);
        szptGdRyxxDTO.setZcxts(1);
        szptGdRyxxDTO.setYsrczjts(1);
        szptGdRyxxDTO.setYsrcbz("1");
        szptGdRyxxDTO.setYsrczts(5);
        szptGdRyxxDTO.setCkbz("1");
        szptGdRyxxDTO.setLkbz("1");
        szptGdRyxxDTO.setHjdzDzmc("1");
        szptGdRyxxDTO.setHjdzXzqhdm("1");
        szptGdRyxxDTO.setHjdzPcsmc("1");
        szptGdRyxxDTO.setHjdzPcsdm("123456");
        szptGdRyxxDTO.setXzdDzmc("1");
        szptGdRyxxDTO.setXzdXzqhdm("5");
        szptGdRyxxDTO.setXzdPcsmc("123456123456");
        szptGdRyxxDTO.setXzdPcsdm("1");
        szptGdRyxxDTO.setZt("1");
        szptGdRyxxDTO.setJcsj(new Date());
        szptGdRyxxDTO.setTcsj(new Date());
        szptGdRyxxDTO.setYjtcsj(new Date());
        szptGdRyxxDTO.setZjzpsj(new Date());
        szptGdRyxxDTO.setSfglry("5");
        szptGdRyxxDTO.setDjzt(1);
        szptGdRyxxDTO.setQyid("1");
        szptGdRyxxDTO.setQymc("1");
        szptGdRyxxDTO.setRylb("1");
        szptGdRyxxDTO.setRylx("1");
        szptGdRyxxDTO.setLkbdsj(new Date());
        szptGdRyxxDTO.setCkbdsj(new Date());
        szptGdRyxxDTO.setDatasource("1");
        szptGdRyxxDTO.setOrderid("1");
        szptGdRyxxDTO.setSjrzrs("123456");

        String json = null;
        try {
            json = objectMapper.writeValueAsString(szptGdRyxxDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
//        String response = webClient.post().uri("/rest/index/addSzptGdRyxx")
        String response = webClient.post().uri("/rest/index/updateSzptGdRyxx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(szptGdRyxxDTO), SzptGdRyxxDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    @Test
    @DisplayName("工地人员信息--删除")
    public void deleteSzptGdRyxxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("1234561234561");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(commonDelDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        String json1 = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json1);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/deleteSzptGdRyxx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(commonDelDTO), CommonDelDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * ===================================================设备信息===================================================
     */
    @Test
    @DisplayName("设备信息--新增、更新")
    public void szptGdSbxxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        SzptGdSbxxDTO szptGdSbxxDTO = new SzptGdSbxxDTO();
        szptGdSbxxDTO.setId("7");
        szptGdSbxxDTO.setSbsn("1");
        szptGdSbxxDTO.setSbmc("1");
        szptGdSbxxDTO.setSbbh("1");
        szptGdSbxxDTO.setSbms("1");
        szptGdSbxxDTO.setMac("1");
        szptGdSbxxDTO.setIp("123456");
        szptGdSbxxDTO.setNetmask("1");
        szptGdSbxxDTO.setGw("5");
        szptGdSbxxDTO.setCsid("1");
        szptGdSbxxDTO.setYxzt("1");
        szptGdSbxxDTO.setZtgxsj(new Date());
        szptGdSbxxDTO.setCj("1");
        szptGdSbxxDTO.setXh("1");
        szptGdSbxxDTO.setQyid("1");
        szptGdSbxxDTO.setQymc("1");
        szptGdSbxxDTO.setSbcs("1");
        szptGdSbxxDTO.setSblb("1");
        szptGdSbxxDTO.setZt("1");
        szptGdSbxxDTO.setSjgsdwdm("330102");
        szptGdSbxxDTO.setSjgsdwmc("1");
        szptGdSbxxDTO.setCreateGajgjgdm("123");
        szptGdSbxxDTO.setCreateGajgmc("123");

        String json = null;
        try {
            json = objectMapper.writeValueAsString(szptGdSbxxDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
//        String response = webClient.post().uri("/rest/index/addSzptGdSbxx")
        String response = webClient.post().uri("/rest/index/updateSzptGdSbxx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(szptGdSbxxDTO), SzptGdSbxxDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    @Test
    @DisplayName("设备信息--删除")
    public void deleteSzptGdSbxxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("4");
        ids.add("5");
        ids.add("6");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(commonDelDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        String json1 = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json1);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/deleteSzptGdSbxx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(commonDelDTO), CommonDelDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * ===================================================工地信息===================================================
     */
    @Test
    @DisplayName("工地信息--新增、更新")
    public void szptGdXxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        SzptGdXxDTO szptGdXxDTO = new SzptGdXxDTO();
        szptGdXxDTO.setId("7");
        szptGdXxDTO.setCslx("1");
        szptGdXxDTO.setCsmc("1111111111111111111");
        szptGdXxDTO.setCsms("1");
        szptGdXxDTO.setLxdz("1");
        szptGdXxDTO.setLxr("1");
        szptGdXxDTO.setLxdh("123456");
        szptGdXxDTO.setSgdw("1");
        szptGdXxDTO.setSgxkz("5");
        szptGdXxDTO.setKgrq(new Date());
        szptGdXxDTO.setYjjgrq(new Date());
        szptGdXxDTO.setLng("120.3");
        szptGdXxDTO.setLat("30");
        szptGdXxDTO.setCustomlng("1");
        szptGdXxDTO.setCustomlat("1");
        szptGdXxDTO.setZrrxm("1");
        szptGdXxDTO.setZrrlxdh("1");
        szptGdXxDTO.setFrxm("1");
        szptGdXxDTO.setFrlxdh("1");
        szptGdXxDTO.setShxydm("330102");
        szptGdXxDTO.setZcdz("1");
        szptGdXxDTO.setAdminzh("123");
        szptGdXxDTO.setSfzcs("1");

        szptGdXxDTO.setFcsid("1");
        szptGdXxDTO.setBz("1");
        szptGdXxDTO.setCjsj(new Date());
        szptGdXxDTO.setZt("1");
        szptGdXxDTO.setJhsj(new Date());
        szptGdXxDTO.setLocation("1");
        szptGdXxDTO.setSjlyXtmc("340102");
        szptGdXxDTO.setZxsj(new Date());
        szptGdXxDTO.setSqdm("123");
        szptGdXxDTO.setSqmc("123");

        szptGdXxDTO.setMdlx("1");
        szptGdXxDTO.setMdjyzt("1");
        szptGdXxDTO.setSjgsdwdm("330102");
        szptGdXxDTO.setSjgsdwmc("1");
        szptGdXxDTO.setCreateGajgjgdm("1");
        szptGdXxDTO.setCreateGajgmc("1");

        String json = null;
        try {
            json = objectMapper.writeValueAsString(szptGdXxDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
//        String response = webClient.post().uri("/rest/index/addSzptGdXx")
        String response = webClient.post().uri("/rest/index/updateSzptGdXx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(szptGdXxDTO), SzptGdXxDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    @Test
    @DisplayName("工地信息--删除")
    public void deleteSzptGdXxTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("1872956891413839873");
        ids.add("1872957357501657089");
        ids.add("1874652891924905986");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(commonDelDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        String json1 = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json1);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/deleteSzptGdXx")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(commonDelDTO), CommonDelDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    /**
     * ===================================================工地预警流水表===================================================
     */
    @Test
    @DisplayName("工地预警流水表--新增、更新")
    public void szptGdYjTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        SzptGdYjDTO szptGdYjDTO = new SzptGdYjDTO();
        szptGdYjDTO.setId("1");
        szptGdYjDTO.setCsid("1");
        szptGdYjDTO.setYjrq("1");
        szptGdYjDTO.setYjlx("1");
        szptGdYjDTO.setYjzlx("1");
        szptGdYjDTO.setYjnr("1");
        szptGdYjDTO.setYwid("123456");
        szptGdYjDTO.setYwcs("1");
        szptGdYjDTO.setYjzt("5");
        szptGdYjDTO.setClsj(new Date());
        szptGdYjDTO.setCljg("123");
        szptGdYjDTO.setClrid("120.3");
        szptGdYjDTO.setClrxm("30");


        String json = null;
        try {
            json = objectMapper.writeValueAsString(szptGdYjDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
//        String response = webClient.post().uri("/rest/index/addSzptGdYj")
        String response = webClient.post().uri("/rest/index/updateSzptGdYj")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(szptGdYjDTO), SzptGdYjDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }

    @Test
    @DisplayName("工地预警流水表--删除")
    public void deleteSzptGdYjTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis() / 1000);
        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("1874653022954954754");
        ids.add("1876882297523142657");
        ids.add("1876882403576119297");

        ids.add("1876882723429670913");
        ids.add("1876883035569774594");
        ids.add("1876887147652833281");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(commonDelDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        String json1 = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json1);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/deleteSzptGdYj")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(commonDelDTO), CommonDelDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }
}
