package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptGdRyxxDTO;
import com.zksy.szpt.domain.po.SzptGdRyxx;
import com.zksy.szpt.mapper.SzptGdRyxxMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptGdRyxxService {
    @Resource
    private SzptGdRyxxMapper szptGdRyxxMapper;

    public Integer addSzptGdRyxx(SzptGdRyxxDTO szptGdRyxxDTO) {
        SzptGdRyxx szptGdRyxx = BeanMapperUtil.map(szptGdRyxxDTO, SzptGdRyxx.class);
        return szptGdRyxxMapper.insert(szptGdRyxx);
    }

    public Integer updateSzptGdRyxx(SzptGdRyxxDTO szptGdRyxxDTO) {
        SzptGdRyxx szptGdRyxx = BeanMapperUtil.map(szptGdRyxxDTO, SzptGdRyxx.class);
        LambdaUpdateWrapper<SzptGdRyxx> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptGdRyxx::getRkbm, szptGdRyxx.getRkbm());
        return szptGdRyxxMapper.update(szptGdRyxx,wrapper);
    }

    public Integer deleteSzptGdRyxx(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptGdRyxx> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptGdRyxx::getRkbm, commonDelDTO.getIds());
        return szptGdRyxxMapper.delete(wrapper);
    }
}
