package com.zksy.szpt.service;

import com.zksy.szpt.domain.UploadImageDTO;
import com.zksy.szpt.domain.po.XxImgfile;
import com.zksy.szpt.exception.NotificationException;
import com.zksy.szpt.mapper.XxImgfileMapper;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;

import java.net.URISyntaxException;

@Service
public class ImageUploadService {
    //日志
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ImageUploadService.class);

    private final XxImgfileMapper xxImgfileMapper;

    // 创建一个 TcpClient 并设置超时时间
    final TcpClient tcpClient = TcpClient.create()
            .option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000) // 连接超时时间
            .doOnConnected(connection -> connection.addHandlerLast(new ReadTimeoutHandler(5)) // 读取超时时间
                    .addHandlerLast(new WriteTimeoutHandler(5))); // 写入超时时间

    public ImageUploadService(XxImgfileMapper xxImgfileMapper) {
        this.xxImgfileMapper = xxImgfileMapper;
    }

    public Integer upload(UploadImageDTO uploadImageDTO) throws NotificationException {
        // 创建 WebClient 实例用于下载文件
        WebClient webClient = WebClient.builder()
                .clientConnector(new ReactorClientHttpConnector(HttpClient.from(tcpClient)))
                .baseUrl(uploadImageDTO.getImagePath())
                .build();
        // 下载文件到内存中的字节数组
        Mono<byte[]> fileContentMono = webClient.get()
                .uri("")
                .retrieve()
                .bodyToMono(byte[].class)
                .onErrorResume(WebClientResponseException.class, ex -> {
                    log.warn("WebClientResponseException: {}", ex.getResponseBodyAsString());
                    return Mono.error(new NotificationException(uploadImageDTO.getImagePath() + "，Failed to download file: " + ex.getStatusText()));
                })
                .onErrorResume(URISyntaxException.class, ex -> {
                    log.warn("URISyntaxException: {}", ex.getMessage());
                    return Mono.error(new NotificationException(uploadImageDTO.getImagePath() + "，Invalid URL format"));
                })
                .onErrorResume(Exception.class, ex -> {
                    log.warn("General Exception: {}", ex.getMessage());
                    return Mono.error(new NotificationException(ex.getMessage()));
                });

        XxImgfile xxImgfile = new XxImgfile();
        xxImgfile.setOurl(uploadImageDTO.getImagePath());
        xxImgfile.setNwzh("0");
        // 等待文件内容下载完成
        try {
            byte[] fileContent = fileContentMono.block();
            if (fileContent == null) {
                throw new NotificationException("Failed to download file");
            }
            xxImgfile.setData(fileContent);
            return xxImgfileMapper.insert(xxImgfile);
        } catch (Exception e) {
            throw new NotificationException(e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
        }
        // 将文件内容插入数据库
//        fileContentMono.flatMap(fileContent -> {
//            try {
//                xxImgfile.setData(fileContent);
//                return Mono.just(xxImgfileMapper.insert(xxImgfile));
//            } catch (Exception e) {
//                e.printStackTrace();
//                return Mono.error(e);
//            }
//        }).subscribe(rowsAffected -> {
//            System.out.println("Rows affected: " + rowsAffected);
//        }, error -> {
//            error.printStackTrace();
//        });
    }
}
