package com.zksy.szpt.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.util.Date;

public class SzptGdYjDTO {
    /**
     * 预警ID
     */
    @ApiModelProperty(value = "预警ID")
    @NotBlank(message = "预警ID不能为空")
    private String id;

    /**
     * 工地ID
     */
    @ApiModelProperty(value = "工地ID")
    @NotBlank(message = "工地ID不能为空")
    private String csid;

    /**
     * 预警日期
     */
    @ApiModelProperty(value = "预警日期")
    @NotBlank(message = "预警日期不能为空")
    private String yjrq;

    /**
     * 预警类型;cslb=3106
     */
    @NotBlank(message = "预警类型不能为空")
    @ApiModelProperty(value = "预警类型('10':'运行状态','20':'设备预警','30':'人员预警','40':'布控车辆')")
    private String yjlx;

    /**
     * 预警子类型;cslb=3139
     */
    @ApiModelProperty(value = "预警子类型('1001':'数据中断','1002':'数据异常','1003':'登记率过低','1004':'房间流量异常','1005':'数据同步接口异常','1006':'人脸聚类接口异常','1007':'疑似空置房','1008':'健康码查询接口异常','1009':'疑似群租房','1010':'企业员工进出异常','1011':'企业来访人员异常','2001':'设备不在线','2002':'设备异常','3001':'重点人员','3002':'疑似入场(异常访客)','3003':'疑似离开','3004':'频繁夜归','3005':'频繁出入','3006':'重点区域频繁进出','3007':'团伙带人','3008':'未戴安全帽','3009':'缺勤注销人员','3010':'外国人入住提醒','3011':'体温过高','3012':'异常健康码','3013':'异常同行','3014':'前科人员','3015':'深夜访客','3016':'关注人员','4001':'布控车辆')")
    private String yjzlx;

    /**
     * 预警内容
     */
    @ApiModelProperty(value = "预警内容")
    private String yjnr;

    /**
     * 业务ID
     */
    @ApiModelProperty(value = "业务ID")
    private String ywid;

    /**
     * 业务参数扩展
     */
    @ApiModelProperty(value = "业务参数扩展")
    private String ywcs;

    /**
     * 预警状态 cslb=3107
     */
    @NotBlank(message = "预警状态不能为空")
    @ApiModelProperty(value = "状态('0':'待确认','1':'已确认')")
    private String yjzt;

    /**
     * 处理时间
     */
    @ApiModelProperty(value = "处理时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date clsj;

    /**
     * 处理结果
     */
    @ApiModelProperty(value = "处理结果")
    private String cljg;

    /**
     * 处理人id
     */
    @ApiModelProperty(value = "处理人id")
    private String clrid;

    /**
     * 处理人姓名
     */
    @ApiModelProperty(value = "处理人姓名")
    private String clrxm;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCsid() {
        return csid;
    }

    public void setCsid(String csid) {
        this.csid = csid == null ? null : csid.trim();
    }

    public String getYjrq() {
        return yjrq;
    }

    public void setYjrq(String yjrq) {
        this.yjrq = yjrq == null ? null : yjrq.trim();
    }

    public String getYjlx() {
        return yjlx;
    }

    public void setYjlx(String yjlx) {
        this.yjlx = yjlx == null ? null : yjlx.trim();
    }

    public String getYjzlx() {
        return yjzlx;
    }

    public void setYjzlx(String yjzlx) {
        this.yjzlx = yjzlx == null ? null : yjzlx.trim();
    }

    public String getYjnr() {
        return yjnr;
    }

    public void setYjnr(String yjnr) {
        this.yjnr = yjnr == null ? null : yjnr.trim();
    }

    public String getYwid() {
        return ywid;
    }

    public void setYwid(String ywid) {
        this.ywid = ywid == null ? null : ywid.trim();
    }

    public String getYwcs() {
        return ywcs;
    }

    public void setYwcs(String ywcs) {
        this.ywcs = ywcs == null ? null : ywcs.trim();
    }

    public String getYjzt() {
        return yjzt;
    }

    public void setYjzt(String yjzt) {
        this.yjzt = yjzt == null ? null : yjzt.trim();
    }

    public Date getClsj() {
        return clsj;
    }

    public void setClsj(Date clsj) {
        this.clsj = clsj;
    }

    public String getCljg() {
        return cljg;
    }

    public void setCljg(String cljg) {
        this.cljg = cljg == null ? null : cljg.trim();
    }

    public String getClrid() {
        return clrid;
    }

    public void setClrid(String clrid) {
        this.clrid = clrid == null ? null : clrid.trim();
    }

    public String getClrxm() {
        return clrxm;
    }

    public void setClrxm(String clrxm) {
        this.clrxm = clrxm == null ? null : clrxm.trim();
    }
}
