package com.zksy.szpt.domain.dto;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;

public class SzptGdCsyjhldxDTO {

    /**
     * 流水ID
     */
    @ApiModelProperty(value = "流水ID")
    @NotBlank(message = "流水ID不能为空")
    private String id;
    /**
     * 场所id
     */
    @ApiModelProperty(value = "场所id")
    @NotBlank(message = "场所id不能为空")
    private String csid;

    /**
     * 预警类型;cslb=3106
     */
    @NotBlank(message = "预警类型不能为空")
    @ApiModelProperty(value = "预警类型('10','运行状态','20','设备预警','30','人员预警','40','布控车辆' )'")
    private String yjlx;

    /**
     * 预警子类型;cslb=3139
     */
    @ApiModelProperty(value = "预警子类型('1001':'数据中断','1002':'数据异常','1003':'登记率过低','1004':'房间流量异常','1005':'数据同步接口异常','1006':'人脸聚类接口异常','1007':'疑似空置房','1008':'健康码查询接口异常','1009':'疑似群租房','1010':'企业员工进出异常','1011':'企业来访人员异常','2001':'设备不在线','2002':'设备异常','3001':'重点人员','3002':'疑似入场(异常访客)','3003':'疑似离开','3004':'频繁夜归','3005':'频繁出入','3006':'重点区域频繁进出','3007':'团伙带人','3008':'未戴安全帽','3009':'缺勤注销人员','3010':'外国人入住提醒','3011':'体温过高','3012':'异常健康码','3013':'异常同行','3014':'前科人员','3015':'深夜访客','3016':'关注人员','4001':'布控车辆')")
    private String yjzlx;

    /**
     * 业务ID
     */
    @ApiModelProperty(value = "业务ID")
    private String ywid;

    /**
     * 业务描述
     */
    @ApiModelProperty(value = "业务描述")
    private String ywms;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    @NotBlank(message = "备注不能为空")
    private String bz;

    /**
     * 状态;cslb=3101
     */
    @ApiModelProperty(value = "状态('1':'有效','2':'注销')")
    private String zt;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCsid() {
        return csid;
    }

    public void setCsid(String csid) {
        this.csid = csid == null ? null : csid.trim();
    }

    public String getYjlx() {
        return yjlx;
    }

    public void setYjlx(String yjlx) {
        this.yjlx = yjlx == null ? null : yjlx.trim();
    }

    public String getYjzlx() {
        return yjzlx;
    }

    public void setYjzlx(String yjzlx) {
        this.yjzlx = yjzlx == null ? null : yjzlx.trim();
    }

    public String getYwid() {
        return ywid;
    }

    public void setYwid(String ywid) {
        this.ywid = ywid == null ? null : ywid.trim();
    }

    public String getYwms() {
        return ywms;
    }

    public void setYwms(String ywms) {
        this.ywms = ywms == null ? null : ywms.trim();
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz == null ? null : bz.trim();
    }

    public String getZt() {
        return zt;
    }

    public void setZt(String zt) {
        this.zt = zt == null ? null : zt.trim();
    }
}
