package com.zksy.szpt.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Date;

public class SzptGdYjDTO {
    /**
     * 工地ID
     */
    @NotBlank(message = "工地ID不能为空")
    private String csid;

    /**
     * 预警日期
     */
    @NotBlank(message = "预警日期不能为空")
    private String yjrq;

    /**
     * 预警类型;cslb=3106
     */
    @NotBlank(message = "预警类型不能为空")
    private String yjlx;

    /**
     * 预警子类型;cslb=3139
     */
    private String yjzlx;

    /**
     * 预警内容
     */
    private String yjnr;

    /**
     * 业务ID
     */
    private String ywid;

    /**
     * 业务参数扩展
     */
    private String ywcs;

    /**
     * 预警状态 cslb=3107
     */
    @NotBlank(message = "预警状态不能为空")
    private String yjzt;

    /**
     * 处理时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date clsj;

    /**
     * 处理结果
     */
    private String cljg;

    /**
     * 处理人id
     */
    private String clrid;

    /**
     * 处理人姓名
     */
    private String clrxm;


    public String getCsid() {
        return csid;
    }

    public void setCsid(String csid) {
        this.csid = csid == null ? null : csid.trim();
    }

    public String getYjrq() {
        return yjrq;
    }

    public void setYjrq(String yjrq) {
        this.yjrq = yjrq == null ? null : yjrq.trim();
    }

    public String getYjlx() {
        return yjlx;
    }

    public void setYjlx(String yjlx) {
        this.yjlx = yjlx == null ? null : yjlx.trim();
    }

    public String getYjzlx() {
        return yjzlx;
    }

    public void setYjzlx(String yjzlx) {
        this.yjzlx = yjzlx == null ? null : yjzlx.trim();
    }

    public String getYjnr() {
        return yjnr;
    }

    public void setYjnr(String yjnr) {
        this.yjnr = yjnr == null ? null : yjnr.trim();
    }

    public String getYwid() {
        return ywid;
    }

    public void setYwid(String ywid) {
        this.ywid = ywid == null ? null : ywid.trim();
    }

    public String getYwcs() {
        return ywcs;
    }

    public void setYwcs(String ywcs) {
        this.ywcs = ywcs == null ? null : ywcs.trim();
    }

    public String getYjzt() {
        return yjzt;
    }

    public void setYjzt(String yjzt) {
        this.yjzt = yjzt == null ? null : yjzt.trim();
    }

    public Date getClsj() {
        return clsj;
    }

    public void setClsj(Date clsj) {
        this.clsj = clsj;
    }

    public String getCljg() {
        return cljg;
    }

    public void setCljg(String cljg) {
        this.cljg = cljg == null ? null : cljg.trim();
    }

    public String getClrid() {
        return clrid;
    }

    public void setClrid(String clrid) {
        this.clrid = clrid == null ? null : clrid.trim();
    }

    public String getClrxm() {
        return clrxm;
    }

    public void setClrxm(String clrxm) {
        this.clrxm = clrxm == null ? null : clrxm.trim();
    }
}
