package com.zksy.szpt.handler;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.handlers.StrictFill;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 自动填充 create_time, update_time 字段
 */
@Component
public class SzptMetaObjectHandler implements MetaObjectHandler {
    @Override
    public void insertFill(MetaObject metaObject) {
        // 新增时自动填充 create_time, update_time 字段
//        this.strictInsertFill(metaObject, "createTime", Date.class, new Date());
//        this.strictInsertFill(metaObject, "cjsj", Date.class, new Date());
        List<StrictFill> fields = Arrays.asList(
                StrictFill.of("createTime", Date.class, new Date()),
                StrictFill.of("cjsj", Date.class, new Date())
        );
        this.strictInsertFill(findTableInfo(metaObject), metaObject, fields);
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        List<StrictFill> fields = Arrays.asList(
                StrictFill.of("updateTime", Date.class, new Date()),
                StrictFill.of("gxrid", String.class, "1"),
                StrictFill.of("gxsj", Date.class, new Date()),
                StrictFill.of("gxrxm", String.class, "测试")
        );
        this.strictInsertFill(findTableInfo(metaObject), metaObject, fields);
//        this.strictInsertFill(metaObject, "updateTime", Date.class, new Date());
    }
}
