package com.zksy.szpt;

import cn.hutool.crypto.digest.DigestUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zksy.szpt.domain.dto.XxRwwcqkDTO;
import com.zksy.szpt.service.AppStoreService;
import com.zksy.szpt.util.EncryptUtil;
import com.zksy.szpt.util.SignatureUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;

/**
 * A simple unit test
 */
@SpringBootTest()
public class MainTest {

    String nonce = "2";
    String timestampStr = "21";
    String appId = "1";


    @Resource
    private ObjectMapper objectMapper;

    @Resource
    private AppStoreService appStoreService;

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("任务完成情况")
    public void xxRwwcqkTest() {
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);

        String secretKey = this.appStoreService.getAppSecretByAppKey(appId);
        Assertions.assertNotNull(secretKey, "appId不存在");//断言appId存在，为空直接抛出异常不进行下一步测试，提高测试效率
//        Assertions.fail(secretKey);
        //请求参数
        XxRwwcqkDTO xxRwwcqkDTO = new XxRwwcqkDTO();
        xxRwwcqkDTO.setRwid("123456");
        xxRwwcqkDTO.setXxyid("123456");
        xxRwwcqkDTO.setShrid("123456");
        xxRwwcqkDTO.setWczt("1");
        xxRwwcqkDTO.setBmzt("1");
        String json = null;
        try {
            json = objectMapper.writeValueAsString(xxRwwcqkDTO);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, secretKey);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri("/rest/index/addXxRwwcqk")
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(xxRwwcqkDTO), XxRwwcqkDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        System.out.println(response);
    }
}
