package com.zksy.szpt.aspect;

import cn.hutool.crypto.digest.DigestUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zksy.szpt.domain.HttpResult;
import com.zksy.szpt.domain.HttpResultState;
import com.zksy.szpt.service.AppStoreService;
import com.zksy.szpt.util.EncryptUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

//@Aspect//声明切面，标记类(1时间，2地点，3内容)
//@Component
public class SignatureAspect {
    private static final Logger logger = LoggerFactory.getLogger(AuthAspect.class);

    @Resource
    AppStoreService appStoreService;

    @Resource
    ObjectMapper objectMapper;

    //
    @Pointcut("execution( * com.zksy.szpt.controller.*.*(..))")
    private void auth() {

    }

    @Around(value = "auth()")
    public Object auth(ProceedingJoinPoint joinPoint) throws Throwable {

        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Object[] paramValues = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature) joinPoint.getSignature()).getParameterNames();

        // 获取请求头中的参数
        String appId = request.getHeader("appId");
        String nonce = request.getHeader("nonce");
        String timestamp = request.getHeader("timestamp");
        String signature = request.getHeader("signature");

        String appSecret = appStoreService.getAppSecretByAppKey(appId);

//        String generatedSignature = EncryptUtil.getInstance().shaEncode(appId + nonce + timestamp + objectMapper.writeValueAsString(paramValues[0]) + appSecret);
        String generatedSignature = DigestUtil.md5Hex(appId + nonce + timestamp + objectMapper.writeValueAsString(paramValues[0]) + appSecret);
        if (!generatedSignature.equals(signature)) {
            logger.error("签名验证失败，请求参数：{}", paramValues[0]);
            HttpResultState httpResultState = HttpResultState.INVALID_SIGNATURE;
            httpResultState.setMessage("签名验证失败");
            return new HttpResult<String>(httpResultState);
        } else {
            return joinPoint.proceed();
        }
    }
}
