package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.service.IndexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class IndexController {
    private final IndexService indexService;

    public IndexController(IndexService indexService) {
        this.indexService = indexService;
    }

    @ApiOperation(value = "新增xx_rwwcqk数据")
    @PostMapping("/addXxRwwcqk")
    public Integer addXxRwwcqk(@RequestBody @Valid XxRwwcqkDTO xxRwwcqkDTO) {
        return indexService.addXxRwwcqk(xxRwwcqkDTO);
    }

    @ApiOperation(value="新增szpt_clock_in数据")
    @PostMapping("/addSzptClockIn")
    public Integer addSzptClockIn(@RequestBody @Validated SzptClockInDTO szptClockInDTO){
        return indexService.addSzptClockIn(szptClockInDTO);
    }

    @ApiOperation(value="新增szpt_clock_in_rules数据")
    @PostMapping("/addSzptClockInRules")
    public Integer addSzptClockInRules(@RequestBody @Validated SzptClockInRulesDTO szptClockInRulesDTO){
        return indexService.addSzptClockInRules(szptClockInRulesDTO);
    }

    @ApiOperation(value="新增房屋信息数据")
    @PostMapping("/addSzptFwxx")
    public Integer addSzptFwxx(@RequestBody @Validated SzptFwxxDTO szptFwxxDTO){
        return indexService.addSzptFwxx(szptFwxxDTO);
    }

    @ApiOperation(value="新增场所预警忽略对象数据")
    @PostMapping("/addSzptGdCsyjhldx")
    public Integer addSzptGdCsyjhldx(@RequestBody @Validated SzptGdCsyjhldxDTO szptGdCsyjhldxDTO){
        return indexService.addSzptGdCsyjhldx(szptGdCsyjhldxDTO);
    }

    @ApiOperation(value="新增工地人员信息数据")
    @PostMapping("/addSzptGdRyxx")
    public Integer addSzptGdRyxx(@RequestBody @Validated SzptGdRyxxDTO szptGdRyxxDTO){
        return indexService.addSzptGdRyxx(szptGdRyxxDTO);
    }

    @ApiOperation(value="新增设备信息数据")
    @PostMapping("/addSzptGdSbxx")
    public Integer addSzptGdSbxx(@RequestBody @Validated SzptGdSbxxDTO szptGdSbxxDTO){
        return indexService.addSzptGdSbxx(szptGdSbxxDTO);
    }

    @ApiOperation(value="新增工地信息数据")
    @PostMapping("/addSzptGdXx")
    public Integer addSzptGdXx(@RequestBody @Validated SzptGdXxDTO szptGdXxDTO){
        return indexService.addSzptGdXx(szptGdXxDTO);
    }

    @ApiOperation(value="新增账号信息数据")
    @PostMapping("/addXxZhxx")
    public Integer addXxZhxx(@RequestBody @Validated XxZhxxDTO xxZhxxDTO){
        return indexService.addXxZhxx(xxZhxxDTO);
    }

    @ApiOperation(value="新增账户积分变更信息数据")
    @PostMapping("/addXxZhjfbg")
    public Integer addXxZhjfbg(@RequestBody @Validated XxZhjfbgDTO dto){
        return indexService.addXxZhjfbg(dto);
    }

    @ApiOperation(value="新增义警任务信息数据")
    @PostMapping("/addXxYjrw")
    public Integer addXxYjrw(@RequestBody @Validated XxYjrwDTO dto){
        return indexService.addXxYjrw(dto);
    }

    @ApiOperation(value="新增义警队伍代码信息数据")
    @PostMapping("/addXxYjdwdm")
    public Integer addXxYjdwdm(@RequestBody @Validated XxYjdwdmDTO dto){
        return indexService.addXxYjdwdm(dto);
    }


    @ApiOperation(value="新增义警队伍代码信息数据")
    @PostMapping("/addXxShxxyDw")
    public Integer XxShxxyDw(@RequestBody @Validated XxShxxyDwDTO dto){
        return indexService.addXxShxxyDw(dto);
    }


    @ApiOperation(value="社会信息员信息数据")
    @PostMapping("/addXxShxxy")
    public Integer addXxShxxy(@RequestBody @Validated XxShxxyDTO dto){
        return indexService.addXxShxxy(dto);
    }

}
