package com.zksy.szpt.domain.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;

@ApiModel(value = "AppStoreDTO", description = "应用商店信息")
public class AppStoreDTO {

    private Long id;

    @ApiModelProperty(value = "应用Key", required = true)
    @NotBlank
    private String appKey;
    @NotBlank
    @ApiModelProperty(value = "密钥", required = true)
    private String appSecret;
    @ApiModelProperty(value = "单位", required = true)
    private String deptCode;

    public String getDeptCode() {
        return deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

}
