package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.XxYjrwDTO;
import com.zksy.szpt.domain.po.XxYjrw;
import com.zksy.szpt.mapper.XxYjrwMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class XxYjrwService {

    @Resource
    private XxYjrwMapper xxYjrwMapper;

    public Integer addXxYjrw(XxYjrwDTO dto) {
        XxYjrw xxYjrw = BeanMapperUtil.map(dto, XxYjrw.class);
        return xxYjrwMapper.insert(xxYjrw);
    }

    public Integer update(XxYjrwDTO dto) {
        XxYjrw xxYjrw = BeanMapperUtil.map(dto, XxYjrw.class);
        LambdaUpdateWrapper<XxYjrw> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(XxYjrw::getRwid, xxYjrw.getRwid());
        return xxYjrwMapper.update(xxYjrw,wrapper);
    }


    public Integer delete(String id) {
        LambdaQueryWrapper<XxYjrw> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(XxYjrw::getRwid, id);
        return xxYjrwMapper.delete(wrapper);
    }
}
