package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.SzptClockInRulesDTO;
import com.zksy.szpt.service.SzptClockInRulesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated

public class SzptClockInRulesController {
    private final SzptClockInRulesService szptClockInRulesService;

    public SzptClockInRulesController(SzptClockInRulesService szptClockInRulesService) {
        this.szptClockInRulesService = szptClockInRulesService;
    }

    @ApiOperation(value="新增szpt_clock_in_rules数据")
    @PostMapping("/addSzptClockInRules")
    public Integer addSzptClockInRules(@RequestBody @Validated SzptClockInRulesDTO szptClockInRulesDTO){
        return szptClockInRulesService.addSzptClockInRules(szptClockInRulesDTO);
    }
}
