package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.SzptClockInDTO;
import com.zksy.szpt.service.SzptClockInService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated


public class SzptClockInController {
    private final SzptClockInService szptClockInService;
    public SzptClockInController(SzptClockInService szptClockInService) {
        this.szptClockInService = szptClockInService;
    }

    @ApiOperation(value="新增szpt_clock_in数据")
    @PostMapping("/addSzptClockIn")
    public Integer addSzptClockIn(@RequestBody @Validated SzptClockInDTO szptClockInDTO){
        return szptClockInService.addSzptClockIn(szptClockInDTO);
    }
}
