package com.zksy.szpt.domain;

public class HttpResult<T> {

    private T data;
    private int code;
    private String message;
    private long timestamp;

    public HttpResult() {
        this.code = HttpResultState.SUCCESS.getCode();
        this.message = HttpResultState.SUCCESS.getMessage();
        this.timestamp = System.currentTimeMillis();
    }

    public HttpResult(T data) {
        this.data = data;
        this.code = HttpResultState.SUCCESS.getCode();
        this.message = HttpResultState.SUCCESS.getMessage();
        this.timestamp = System.currentTimeMillis();
    }

    public HttpResult(HttpResultState state) {
        this.code = state.getCode();
        this.message = state.getMessage();
        this.timestamp = System.currentTimeMillis();
    }


    public static <T> HttpResult<T> success() {
        return new HttpResult<>();
    }

    public static <T> HttpResult<T> success(T data) {
        return new HttpResult<>(data);
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}