package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptGdYjDTO;
import com.zksy.szpt.domain.po.SzptGdYj;
import com.zksy.szpt.mapper.SzptGdYjMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptGdYjService {
    @Resource
    private SzptGdYjMapper szptGdYjMapper;
    public Integer addSzptGdYj(SzptGdYjDTO szptGdYjDTO){
        SzptGdYj szptGdYj = BeanMapperUtil.map(szptGdYjDTO,SzptGdYj.class);
        return szptGdYjMapper.insert(szptGdYj);
    }

    public Integer updateSzptGdYj(SzptGdYjDTO szptGdYjDTO) {
        SzptGdYj szptGdYj = BeanMapperUtil.map(szptGdYjDTO, SzptGdYj.class);
        LambdaUpdateWrapper<SzptGdYj> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptGdYj::getId, szptGdYj.getId());
        return szptGdYjMapper.update(szptGdYj,wrapper);
    }

    public Integer deleteSzptGdYj(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptGdYj> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptGdYj::getId, commonDelDTO);
        return szptGdYjMapper.delete(wrapper);
    }
}
