package com.zksy.szpt.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zksy.szpt.domain.CommonRequestDTO;
import com.zksy.szpt.util.EncryptUtil;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

import javax.annotation.Resource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

@RestControllerAdvice(basePackages = "com.zksy.szpt.controller")
@ConditionalOnBean(name = "signatureVerificationFilter2")
public class RequestBodyAnalysis implements RequestBodyAdvice {
    @Resource
    private ObjectMapper objectMapper;
    @Override
    public boolean supports(MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        return methodParameter.hasParameterAnnotation(RequestBody.class);
    }

    @Override
    public HttpInputMessage beforeBodyRead(HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) throws IOException {
        return new HttpInputMessage() {

            @Override
            public HttpHeaders getHeaders() {
                return httpInputMessage.getHeaders();
            }

            @Override
            public InputStream getBody() throws IOException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy(httpInputMessage.getBody(), baos);
                CommonRequestDTO commonRequestDTO = objectMapper.readValue(new String(baos.toByteArray(), StandardCharsets.UTF_8), CommonRequestDTO.class);
                String content = EncryptUtil.getInstance().AESDecode(commonRequestDTO.getContent(), "c81e728d9d4c2f636f067f89cc14862c");
                return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            }
        };
    }

    @Override
    public Object afterBodyRead(Object o, HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        return o;
    }

    @Override
    public Object handleEmptyBody(Object o, HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        return o;
    }
}
