package com.zksy.szpt;

import cn.hutool.crypto.digest.DigestUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zksy.szpt.domain.CommonRequestDTO;
import com.zksy.szpt.util.EncryptUtil;
import com.zksy.szpt.util.SignatureUtil;
import org.junit.jupiter.api.Assertions;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class TestHttpUtil {
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(TestHttpUtil.class);
    static String nonce = "2";
    static String timestampStr = "21";
    static String appId = "1872576325743943682";
    static String appSecret = DigestUtil.md5Hex("2");;
    static String deptCode = "330102";

    private static final ObjectMapper objectMapper = new ObjectMapper();

    //body {单位， 房间， 人员信息数组}  请求头加nonce timestamp appId sign(body[遍历按照key按照顺序&拼接] 加 nonece timestamp appId 用$符号拼接)
    public static <E, T> void signatureAndRequest(String path, T source, Class<E> destinationClass) {
        Assertions.assertNotNull(path, "path不能为空");
        Assertions.assertNotNull(source, "请求参数不能为空");
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis());
        String json = null;
        try {
            json = objectMapper.writeValueAsString(source);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
//        log.info("请求参数appId: {}, nonce: {}, timestampStr: {}, 原始body: {}", appId, nonce, timestampStr, json);
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, appSecret);
//        log.info("{}加密后json: {}", appSecret,json);
        //签名appId+nonce+timestampStr+aes(body)
        String data = String.format("%s%s%s%s", appId, nonce, timestampStr, json);
        String generatedSignature = DigestUtil.md5Hex(data);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri(path)
                .header(SignatureUtil.APPID, appId)
                .header(SignatureUtil.NONCE, nonce)
                .header(SignatureUtil.TIMESTAMP, timestampStr)
                .header(SignatureUtil.SIGNATURE, generatedSignature)
                .body(Mono.just(source), destinationClass)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        log.info("response: {}", response);
    }

    //body { appkey , method , hotelCode , content（根据密钥[md5]对dto的json加密aes）, sign(前面的参数一起哈希运算)}  。 无其他参数
    public static <T> void signatureAndRequest(String path, T source) {
        Assertions.assertNotNull(path, "path不能为空");
        Assertions.assertNotNull(source, "请求参数不能为空");
        timestampStr = String.valueOf(System.currentTimeMillis() / 1000);
        nonce = String.valueOf(System.currentTimeMillis());
        String json = null;
        try {
            json = objectMapper.writeValueAsString(source);
        } catch (JsonProcessingException e) {
            Assertions.fail("json序列化失败");
        }
        //请求体加密
        //请求体加密
        json = EncryptUtil.getInstance().AESEncode(json, appSecret);
        //签名appId+nonce+timestampStr+aes(body)+deptCode
        String data = String.format("%s%s%s%s%s", appId, nonce, timestampStr, json, deptCode);
        String generatedSignature = DigestUtil.md5Hex(data);

        CommonRequestDTO commonRequestDTO = new CommonRequestDTO();
        commonRequestDTO.setAppId(appId);
        commonRequestDTO.setNonce(nonce);
        commonRequestDTO.setTimestamp(timestampStr);
        commonRequestDTO.setDeptCode(deptCode);
        commonRequestDTO.setContent(json);
        commonRequestDTO.setSign(generatedSignature);
        //请求
        WebClient webClient = WebClient.builder()
                .baseUrl("http://localhost:8086")
                .defaultHeader("Content-Type", "application/json")
                .build();
        String response = webClient.post().uri(path)
                .body(Mono.just(commonRequestDTO), CommonRequestDTO.class)
                .retrieve()
                .bodyToMono(String.class)
                .block();
        log.info("response: {}", response);
    }
}
