package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelParamDTO;
import com.zksy.szpt.domain.dto.XxZhjfbgDTO;
import com.zksy.szpt.service.XxZhjfbgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "账户积分变更信息服务")
@RequestMapping("/rest/xxZhjfbg")
@RestController
@Validated
public class XxZhjfbgController {
    private final XxZhjfbgService service;

    public XxZhjfbgController(XxZhjfbgService service) {
        this.service = service;
    }

    @ApiOperation(value = "新增账户积分变更数据")
    @PostMapping("/add")
    public Integer addXxZhjfbg(@RequestBody @Validated XxZhjfbgDTO dto) {
        return service.addXxZhjfbg(dto);
    }

    @ApiOperation(value = "修改账户积分变更数据")
    @PostMapping("/update")
    public Integer update(@RequestBody @Validated XxZhjfbgDTO dto) {
        return service.update(dto);
    }


    @ApiOperation(value = "根据兑换ID删除账户积分变更数据")
    @PostMapping("/delete")
    public Integer delete(@RequestBody  @Validated CommonDelParamDTO dto) {
        return service.delete(dto);
    }

}
