package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptClockInDTO;
import com.zksy.szpt.service.SzptClockInService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptClockInController {
    private final SzptClockInService szptClockInService;
    public SzptClockInController(SzptClockInService szptClockInService) {
        this.szptClockInService = szptClockInService;
    }

    @ApiOperation(value="新增szpt_clock_in数据")
    @PostMapping("/addSzptClockIn")
    public Integer addSzptClockIn(@RequestBody @Validated SzptClockInDTO szptClockInDTO){
        return szptClockInService.addSzptClockIn(szptClockInDTO);
    }

    @ApiOperation(value="编辑szpt_clock_in数据")
    @PostMapping("/updateSzptClockIn")
    public Integer updateSzptClockIn(@RequestBody @Validated SzptClockInDTO szptClockInDTO){
        return szptClockInService.updateSzptClockIn(szptClockInDTO);
    }

    @ApiOperation(value = "删除szpt_clock_in数据")
    @PostMapping("/deleteSzptClockIn")
    public Integer deleteSzptClockIn(@RequestBody CommonDelDTO commonDelDTO) {
        return szptClockInService.deleteSzptClockIn(commonDelDTO);
    }


}
