package com.zksy.szpt.domain.dto;


import com.zksy.szpt.domain.ValidationGroups;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;

@ApiModel(value = "AppStoreDTO", description = "应用商店信息")
public class AppStoreDTO {
    @ApiModelProperty(value = "应用Key", required = true)
    @NotBlank(groups = {ValidationGroups.Update.class}, message = "应用Key不能为空")
    private String appKey;

    @NotBlank(message = "密钥不能为空")
    @ApiModelProperty(value = "密钥", required = true)

    private String appSecret;
    @ApiModelProperty(value = "单位", required = false)
    private String deptCode;

    public String getDeptCode() {
        return deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }


    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

}
