package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zksy.szpt.domain.PageInfo;
import com.zksy.szpt.domain.bo.SzptClockInBO;
import com.zksy.szpt.domain.bo.SzptFwxxBO;
import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.domain.po.SzptClockIn;
import com.zksy.szpt.domain.po.SzptFwxx;
import com.zksy.szpt.mapper.SzptClockInMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import com.zksy.szpt.util.UserContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class SzptClockInService {
    @Resource
    private SzptClockInMapper szptClockInMapper;

    public PageInfo<SzptClockInBO> querySzptClockIn(SzptClockInQueryDTO szptClockInQueryDTO) {
        String deptCode  = UserContextHolder.get().getDeptCode();
        if(deptCode==null){
            throw new IllegalArgumentException("所属单位为空");
        }
        LambdaQueryWrapper<SzptClockIn> wrapper = new LambdaQueryWrapper<>();
//        wrapper.eq(SzptClockIn::getSjgsdwdm, deptCode);
        if (szptClockInQueryDTO.getCsid() != null) {
            wrapper.eq(SzptClockIn::getCsid, szptClockInQueryDTO.getCsid());
        }
        Page<SzptClockIn> page = new Page<>(szptClockInQueryDTO.getPageNum(),szptClockInQueryDTO.getPageSize());
        Page<SzptClockIn> resultPage = szptClockInMapper.selectPage(page,wrapper);
        List<SzptClockInBO> list = BeanMapperUtil.mapList(resultPage.getRecords(), SzptClockInBO.class);
        return new PageInfo<>(resultPage.getTotal(),list,resultPage.getCurrent(),resultPage.getSize());
    }


    public Integer addSzptClockIn(SzptClockInDTO szptClockInDTO) {
        SzptClockIn szptClockIn = BeanMapperUtil.map(szptClockInDTO, SzptClockIn.class);
        return szptClockInMapper.insert(szptClockIn);
    }

    public Integer updateSzptClockIn(SzptClockInDTO szptClockInDTO) {
        SzptClockIn szptClockIn = BeanMapperUtil.map(szptClockInDTO, SzptClockIn.class);
        LambdaUpdateWrapper<SzptClockIn> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptClockIn::getId, szptClockIn.getId());
        return szptClockInMapper.update(szptClockIn,wrapper);
    }

    public Integer deleteSzptClockIn(CommonDelIntDTO commonDelIntDTO) {
        LambdaQueryWrapper<SzptClockIn> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptClockIn::getId, commonDelIntDTO.getIds());
        return szptClockInMapper.delete(wrapper);
    }
}
