package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zksy.szpt.domain.PageInfo;
import com.zksy.szpt.domain.bo.SzptFwxxBO;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptFwxxDTO;
import com.zksy.szpt.domain.dto.SzptFwxxQueryDTO;
import com.zksy.szpt.domain.po.SzptFwxx;
import com.zksy.szpt.mapper.SzptFwxxMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import com.zksy.szpt.util.UserContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class SzptFwxxService {

    @Resource
    private SzptFwxxMapper szptFwxxMapper;

    public PageInfo<SzptFwxxBO> querySzptFwxx(SzptFwxxQueryDTO szptFwxxQueryDTO) {
            String deptCode  = UserContextHolder.get().getDeptCode();
            if(deptCode==null){
                throw new IllegalArgumentException("所属单位为空");
            }
            LambdaQueryWrapper<SzptFwxx> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SzptFwxx::getSjgsdwdm, deptCode);
            if (szptFwxxQueryDTO.getQyid() != null) {
                wrapper.eq(SzptFwxx::getQyid, szptFwxxQueryDTO.getQyid());
            }
            Page<SzptFwxx> page = new Page<>(szptFwxxQueryDTO.getPageNum(),szptFwxxQueryDTO.getPageSize());
            Page<SzptFwxx> resultPage = szptFwxxMapper.selectPage(page,wrapper);
            List<SzptFwxxBO> list = BeanMapperUtil.mapList(resultPage.getRecords(), SzptFwxxBO.class);
            return new PageInfo<>(resultPage.getTotal(),list,resultPage.getCurrent(),resultPage.getSize());
    }

    public Integer addSzptFwxx(SzptFwxxDTO szptFwxxDTO) {
        SzptFwxx szptFwxx = BeanMapperUtil.map(szptFwxxDTO, SzptFwxx.class);
        return szptFwxxMapper.insert(szptFwxx);
    }

    public Integer updateSzptFwxx(SzptFwxxDTO szptFwxxDTO) {
        SzptFwxx szptFwxx = BeanMapperUtil.map(szptFwxxDTO, SzptFwxx.class);
        LambdaUpdateWrapper<SzptFwxx> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptFwxx::getQyid, szptFwxx.getQyid());
        wrapper.eq(SzptFwxx::getSjgsdwdm, UserContextHolder.get().getDeptCode());
        return szptFwxxMapper.update(szptFwxx,wrapper);
    }

    public Integer deleteSzptFwxx(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptFwxx> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptFwxx::getQyid, commonDelDTO.getIds());
        wrapper.eq(SzptFwxx::getSjgsdwdm, UserContextHolder.get().getDeptCode());
//        wrapper.eq(SzptFwxx::getSjgsdwdm, commonDelDTO.getSjgsdwdm());
        return szptFwxxMapper.delete(wrapper);
    }
}
