package com.zksy.szpt.util;

import com.zksy.szpt.domain.CurrentUserInfo;

/**
 * 保存当前http请求的用户登录信息
 */
public class UserContextHolder {
    private static final ThreadLocal<CurrentUserInfo> userThread = new ThreadLocal<>();

    public static void set(CurrentUserInfo user){
        userThread.set(user);
    }

    public static CurrentUserInfo get(){
        return userThread.get();
    }

    //防止内存泄漏
    public static void remove(){
        userThread.remove();
    }
}
