package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptGdXxDTO;
import com.zksy.szpt.domain.po.SzptGdSbxx;
import com.zksy.szpt.domain.po.SzptGdXx;
import com.zksy.szpt.mapper.SzptGdXxMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import com.zksy.szpt.util.UserContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptGdXxService {
    @Resource
    private SzptGdXxMapper szptGdXxMapper;

    public Integer addSzptGdXx(SzptGdXxDTO szptGdXxDTO) {
        SzptGdXx szptGdXx = BeanMapperUtil.map(szptGdXxDTO, SzptGdXx.class);
        return szptGdXxMapper.insert(szptGdXx);
    }

    public Integer updateSzptGdXx(SzptGdXxDTO szptGdXxDTO) {
        SzptGdXx szptGdXx = BeanMapperUtil.map(szptGdXxDTO, SzptGdXx.class);
        LambdaUpdateWrapper<SzptGdXx> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptGdXx::getId, szptGdXx.getId());
        wrapper.eq(SzptGdXx::getSjgsdwdm, szptGdXx.getSjgsdwdm());
        return szptGdXxMapper.update(szptGdXx,wrapper);
    }

    public Integer deleteSzptGdXx(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptGdXx> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptGdXx::getId, commonDelDTO.getIds());
        wrapper.eq(SzptGdXx::getSjgsdwdm, UserContextHolder.get().getDeptCode());
//        wrapper.eq(SzptGdXx::getSjgsdwdm, commonDelDTO.getSjgsdwdm());
        return szptGdXxMapper.delete(wrapper);
    }
}
