package com.zksy.szpt.config;

import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.TopLevelClass;

import java.util.List;

/**
 * mapper接口增加继承BaseMapper
 */
public class BaseMapperPlugin extends PluginAdapter {

    private static final String BASE_MAPPER = "com.baomidou.mybatisplus.core.mapper.BaseMapper";

    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        // 导入 BaseMapper
        FullyQualifiedJavaType baseMapperType = new FullyQualifiedJavaType(BASE_MAPPER);
        FullyQualifiedJavaType entityType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());

        // 让 Mapper 继承 BaseMapper<Entity>
        FullyQualifiedJavaType superInterface = new FullyQualifiedJavaType(
                String.format("%s<%s>", BASE_MAPPER, entityType.getShortName()));

        interfaze.addSuperInterface(superInterface);
        interfaze.addImportedType(baseMapperType);
        interfaze.addImportedType(entityType);

        return true;
    }
}

